package com.vungle.warren.downloader;

import androidx.annotation.NonNull;

public class AssetPriority implements Comparable {

    private final Integer firstPriority;

    private final Integer secondPriority;

    public AssetPriority(int firstPriority, @DownloadRequest.Priority int secondPriority) {
        this.firstPriority = firstPriority;
        this.secondPriority = secondPriority;
    }

    @Override
    public int compareTo(Object o) {
        /* Here we check autoCachePriority first, if this.autoCachePriority is less than o.autoCachePriority,
         * then this will be handled first.
         * If they have same autoCachePriority, we will check asset priority.
         * According to AND-3415, template.zip will have higher priority than other assets.
         */
        if (o instanceof AssetPriority) {
            int ret = this.firstPriority.compareTo(((AssetPriority) o).firstPriority);
            if (ret == 0) {
                return this.secondPriority.compareTo(((AssetPriority) o).secondPriority);
            }
            return ret;
        }
        return -1;
    }

    @NonNull
    @Override
    public String toString() {
        return "AssetPriority{" +
                "firstPriority=" + this.firstPriority +
                ", secondPriority=" + this.secondPriority +
                '}';
    }
}
