package com.vungle.warren.downloader;

import androidx.annotation.IntDef;
import androidx.annotation.Nullable;

import java.util.List;

public interface Downloader {

    void download(DownloadRequest downloadRequest, AssetDownloadListener downloadListener);

    List<DownloadRequest> getAllRequests();

    void cancel(@Nullable DownloadRequest request);

    boolean cancelAndAwait(@Nullable DownloadRequest request, long timeout);

    void cancelAll();

    void setProgressStep(int value);

    void init();

    void clearCache();

    boolean dropCache(String serverPath);

    boolean isCacheEnabled();

    void setCacheEnabled(boolean isEnabled);

    void updatePriority(DownloadRequest request);

    @IntDef(flag = true, value = {NetworkType.WIFI, NetworkType.CELLULAR, NetworkType.ANY})
    @interface NetworkType {
        int CELLULAR = 1;
        int WIFI = 1 << 1;
        int ANY = CELLULAR | WIFI;
    }

    class RequestException extends Exception {

        RequestException(String message) {
            super(message);
        }

    }
}
