package com.vungle.warren.model;

import static com.vungle.warren.persistence.ContentValuesUtil.getBoolean;

import android.content.ContentValues;
import android.util.Pair;

import androidx.annotation.NonNull;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.vungle.warren.AdConfig;
import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by Alexander Semenov on 22-Oct-18.
 */
public class AdvertisementDBAdapter implements DBAdapter<Advertisement> {

    private Gson gson = new GsonBuilder().create();
    private Type stringArrayType = new TypeToken<String[]>() {
    }.getType();
    private Type stringMapType = new TypeToken<Map<String, String>>() {
    }.getType();
    static final Type CHECKPOINT_LIST_TYPE = new TypeToken<List<Advertisement.Checkpoint>>() {
    }.getType();
    static final Type DYNAMIC_EVENTS_AND_URLS_TYPE = new TypeToken<Map<String, ArrayList<String>>>() {
    }.getType();
    private Type cacheableMapType = new TypeToken<Map<String, Pair<String, String>>>() {
    }.getType();

    private final Type STRING_LIST_TYPE = new TypeToken<List<String>>() {}.getType();

    @Override
    public ContentValues toContentValues(Advertisement item) {
        ContentValues contentValues = new ContentValues();

        contentValues.put(AdvertisementColumns.COLUMN_IDENTIFIER, item.identifier);
        contentValues.put(AdvertisementColumns.COLUMN_AD_TYPE, item.getAdType());
        contentValues.put(AdvertisementColumns.COLUMN_EXPIRE_TIME, item.expireTime);
        contentValues.put(AdvertisementColumns.COLUMN_DELAY, item.delay);
        contentValues.put(AdvertisementColumns.COLUMN_SHOW_CLOSE_DELAY, item.showCloseDelay);
        contentValues.put(AdvertisementColumns.COLUMN_SHOW_CLOSE_INCENTIVISED, item.showCloseIncentivized);
        contentValues.put(AdvertisementColumns.COLUMN_COUNTDOWN, item.countdown);
        contentValues.put(AdvertisementColumns.COLUMN_VIDEO_WIDTH, item.videoWidth);
        contentValues.put(AdvertisementColumns.COLUMN_VIDEO_HEIGHT, item.videoHeight);
        contentValues.put(AdvertisementColumns.COLUMN_CTA_OVERLAY_ENABLED, item.ctaOverlayEnabled);
        contentValues.put(AdvertisementColumns.COLUMN_CTA_CLICK_AREA, item.ctaClickArea);
        contentValues.put(AdvertisementColumns.COLUMN_RETRY_COUNT, item.retryCount);
        contentValues.put(AdvertisementColumns.COLUMN_REQUIRES_NON_MARKET_INSTALL, item.requiresNonMarketInstall);
        contentValues.put(AdvertisementColumns.COLUMN_APP_ID, item.appID);
        contentValues.put(AdvertisementColumns.COLUMN_CAMPAIGN, item.campaign);
        contentValues.put(AdvertisementColumns.COLUMN_VIDEO_URL, item.videoUrl);
        contentValues.put(AdvertisementColumns.COLUMN_MD5, item.md5);
        contentValues.put(AdvertisementColumns.COLUMN_POSTROLL_BUNDLE_URL, item.postrollBundleUrl);
        contentValues.put(AdvertisementColumns.COLUMN_CTA_DESTINATION_URL, item.ctaDestinationUrl);
        contentValues.put(AdvertisementColumns.COLUMN_CTA_URL, item.ctaUrl);
        contentValues.put(AdvertisementColumns.COLUMN_AD_TOKEN, item.adToken);
        contentValues.put(AdvertisementColumns.COLUMN_VIDEO_IDENTIFIER, item.videoIdentifier);
        contentValues.put(AdvertisementColumns.COLUMN_TEMPLATE_URL, item.templateUrl);
        contentValues.put(AdvertisementColumns.COLUMN_TEMPLATE_ID, item.templateId);
        contentValues.put(AdvertisementColumns.COLUMN_TEMPLATE_TYPE, item.templateType);
        contentValues.put(AdvertisementColumns.COLUMN_AD_MARKET_ID, item.adMarketId);
        contentValues.put(AdvertisementColumns.COLUMN_BID_TOKEN, item.bidToken);
        contentValues.put(AdvertisementColumns.COLUMN_STATE, item.state);
        contentValues.put(AdvertisementColumns.COLUMN_PLACEMENT_ID, item.placementId);
        contentValues.put(AdvertisementColumns.COLUMN_AD_CONFIG, gson.toJson(item.adConfig));

        contentValues.put(AdvertisementColumns.COLUMN_CHECKPOINTS, gson.toJson(item.checkpoints, CHECKPOINT_LIST_TYPE));
        contentValues.put(AdvertisementColumns.COLUMN_DYNAMIC_EVENTS_AND_URLS,
                gson.toJson(item.dynamicEventsAndUrls, DYNAMIC_EVENTS_AND_URLS_TYPE));

        contentValues.put(AdvertisementColumns.COLUMN_TEMPLATE_SETTINGS, gson.toJson(item.templateSettings, stringMapType));
        contentValues.put(AdvertisementColumns.COLUMN_MRAID_FILES, gson.toJson(item.mraidFiles, stringMapType));
        contentValues.put(AdvertisementColumns.COLUMN_CACHEABLE_ASSETS, gson.toJson(item.cacheableAssets, cacheableMapType));
        contentValues.put(AdvertisementColumns.COLUMN_NOTIFICATIONS, gson.toJson(item.getWinNotifications(), STRING_LIST_TYPE));
        contentValues.put(AdvertisementColumns.COLUMN_TT_DOWNLOAD, item.ttDownload);
        contentValues.put(AdvertisementColumns.COLUMN_ASSET_DOWNLOAD_TIMESTAMP, item.assetDownloadStartTime);
        contentValues.put(AdvertisementColumns.COLUMN_ASSET_DOWNLOAD_DURATION, item.assetDownloadDuration);
        contentValues.put(AdvertisementColumns.COLUMN_AD_REQUEST_START_TIMESTAMP, item.adRequestStartTime);
        contentValues.put(AdvertisementColumns.COLUMN_ENABLE_OM_SDK, item.enableOm);
        contentValues.put(AdvertisementColumns.COLUMN_OM_SDK_EXTRA_VAST, item.omExtraVast);
        contentValues.put(AdvertisementColumns.COLUMN_SERVER_REQUEST_TIMESTAMP, item.serverRequestTimestamp);
        contentValues.put(AdvertisementColumns.COLUMN_CLICK_COORDINATES_ENABLED, item.clickCoordinatesEnabled);
        contentValues.put(AdvertisementColumns.COLUMN_ASSETS_FULLY_DOWNLOADED, item.assetsFullyDownloaded);
        contentValues.put(AdvertisementColumns.COLUMN_DEEP_LINK, item.deeplink);
        contentValues.put(AdvertisementColumns.COLUMN_HEADER_BIDDING, item.headerBidding);
        return contentValues;
    }

    @NonNull
    @Override
    public Advertisement fromContentValues(ContentValues values) {
        Advertisement item = new Advertisement();

        item.identifier = values.getAsString(AdvertisementColumns.COLUMN_IDENTIFIER);
        item.adType = values.getAsInteger(AdvertisementColumns.COLUMN_AD_TYPE);
        item.expireTime = values.getAsLong(AdvertisementColumns.COLUMN_EXPIRE_TIME);
        item.delay = values.getAsInteger(AdvertisementColumns.COLUMN_DELAY);
        item.showCloseDelay = values.getAsInteger(AdvertisementColumns.COLUMN_SHOW_CLOSE_DELAY);
        item.showCloseIncentivized = values.getAsInteger(AdvertisementColumns.COLUMN_SHOW_CLOSE_INCENTIVISED);
        item.countdown = values.getAsInteger(AdvertisementColumns.COLUMN_COUNTDOWN);
        item.videoWidth = values.getAsInteger(AdvertisementColumns.COLUMN_VIDEO_WIDTH);
        item.videoHeight = values.getAsInteger(AdvertisementColumns.COLUMN_VIDEO_HEIGHT);
        item.retryCount = values.getAsInteger(AdvertisementColumns.COLUMN_RETRY_COUNT);
        item.requiresNonMarketInstall = getBoolean(values, AdvertisementColumns.COLUMN_REQUIRES_NON_MARKET_INSTALL);
        item.appID = values.getAsString(AdvertisementColumns.COLUMN_APP_ID);
        item.campaign = values.getAsString(AdvertisementColumns.COLUMN_CAMPAIGN);
        item.videoUrl = values.getAsString(AdvertisementColumns.COLUMN_VIDEO_URL);
        item.md5 = values.getAsString(AdvertisementColumns.COLUMN_MD5);
        item.postrollBundleUrl = values.getAsString(AdvertisementColumns.COLUMN_POSTROLL_BUNDLE_URL);
        item.ctaDestinationUrl = values.getAsString(AdvertisementColumns.COLUMN_CTA_DESTINATION_URL);
        item.ctaUrl = values.getAsString(AdvertisementColumns.COLUMN_CTA_URL);
        item.adToken = values.getAsString(AdvertisementColumns.COLUMN_AD_TOKEN);
        item.videoIdentifier = values.getAsString(AdvertisementColumns.COLUMN_VIDEO_IDENTIFIER);
        item.templateUrl = values.getAsString(AdvertisementColumns.COLUMN_TEMPLATE_URL);
        item.templateId = values.getAsString(AdvertisementColumns.COLUMN_TEMPLATE_ID);
        item.templateType = values.getAsString(AdvertisementColumns.COLUMN_TEMPLATE_TYPE);
        item.adMarketId = values.getAsString(AdvertisementColumns.COLUMN_AD_MARKET_ID);
        item.bidToken = values.getAsString(AdvertisementColumns.COLUMN_BID_TOKEN);
        item.state = values.getAsInteger(AdvertisementColumns.COLUMN_STATE);
        item.placementId = values.getAsString(AdvertisementColumns.COLUMN_PLACEMENT_ID);
        item.ctaOverlayEnabled = getBoolean(values, AdvertisementColumns.COLUMN_CTA_OVERLAY_ENABLED);
        item.ctaClickArea = getBoolean(values, AdvertisementColumns.COLUMN_CTA_CLICK_AREA);
        item.adConfig = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_AD_CONFIG), AdConfig.class);

        item.checkpoints = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_CHECKPOINTS), CHECKPOINT_LIST_TYPE);
        item.dynamicEventsAndUrls = gson.fromJson(
                values.getAsString(AdvertisementColumns.COLUMN_DYNAMIC_EVENTS_AND_URLS),
                DYNAMIC_EVENTS_AND_URLS_TYPE);

        item.templateSettings = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_TEMPLATE_SETTINGS), stringMapType);
        item.mraidFiles = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_MRAID_FILES), stringMapType);
        item.cacheableAssets = gson.fromJson(values.getAsString(AdvertisementColumns.COLUMN_CACHEABLE_ASSETS), cacheableMapType);
        item.ttDownload = values.getAsLong(AdvertisementColumns.COLUMN_TT_DOWNLOAD);
        item.assetDownloadStartTime = values.getAsLong(AdvertisementColumns.COLUMN_ASSET_DOWNLOAD_TIMESTAMP);
        item.assetDownloadDuration = values.getAsLong(AdvertisementColumns.COLUMN_ASSET_DOWNLOAD_DURATION);
        item.adRequestStartTime = values.getAsLong(AdvertisementColumns.COLUMN_AD_REQUEST_START_TIMESTAMP);
        item.enableOm = getBoolean(values, AdvertisementColumns.COLUMN_ENABLE_OM_SDK);
        List<String> notificationUrls = gson.fromJson(
                values.getAsString(AdvertisementColumns.COLUMN_NOTIFICATIONS),
                STRING_LIST_TYPE);
        item.setWinNotifications(notificationUrls);
        item.omExtraVast = values.getAsString(AdvertisementColumns.COLUMN_OM_SDK_EXTRA_VAST);
        item.serverRequestTimestamp = values.getAsLong(AdvertisementColumns.COLUMN_SERVER_REQUEST_TIMESTAMP);
        item.clickCoordinatesEnabled = values.getAsBoolean(AdvertisementColumns.COLUMN_CLICK_COORDINATES_ENABLED);
        item.assetsFullyDownloaded = getBoolean(values, AdvertisementColumns.COLUMN_ASSETS_FULLY_DOWNLOADED);
        item.deeplink = values.getAsString(AdvertisementColumns.COLUMN_DEEP_LINK);
        item.headerBidding = values.getAsBoolean(AdvertisementColumns.COLUMN_HEADER_BIDDING);
        return item;
    }

    @Override
    public String tableName() {
        return AdvertisementColumns.TABLE_NAME;
    }

    public interface AdvertisementColumns extends IdColumns {
        String TABLE_NAME = "advertisement";
        String COLUMN_AD_TYPE = "ad_type";
        String COLUMN_APP_ID = "app_id";
        String COLUMN_EXPIRE_TIME = "expire_time";
        String COLUMN_CHECKPOINTS = "checkpoints";
        String COLUMN_DYNAMIC_EVENTS_AND_URLS = "dynamic_events_and_urls";

        String COLUMN_DELAY = "delay";
        String COLUMN_CAMPAIGN = "campaign";
        String COLUMN_SHOW_CLOSE_DELAY = "show_close_delay";
        String COLUMN_SHOW_CLOSE_INCENTIVISED = "show_close_incentivized";
        String COLUMN_COUNTDOWN = "countdown";
        String COLUMN_VIDEO_URL = "video_url";
        String COLUMN_VIDEO_WIDTH = "video_width";
        String COLUMN_VIDEO_HEIGHT = "video_height";
        String COLUMN_MD5 = "md5";
        String COLUMN_POSTROLL_BUNDLE_URL = "postroll_bundle_url";
        String COLUMN_CTA_OVERLAY_ENABLED = "cta_overlay_enabled";
        String COLUMN_CTA_CLICK_AREA = "cta_click_area";
        String COLUMN_CTA_DESTINATION_URL = "cta_destination_url";
        String COLUMN_CTA_URL = "cta_url";
        String COLUMN_AD_CONFIG = "ad_config";
        String COLUMN_RETRY_COUNT = "retry_count";
        String COLUMN_AD_TOKEN = "ad_token";
        String COLUMN_VIDEO_IDENTIFIER = "video_identifier";
        String COLUMN_TEMPLATE_URL = "template_url";
        String COLUMN_TEMPLATE_SETTINGS = "template_settings";
        String COLUMN_MRAID_FILES = "mraid_files";
        String COLUMN_TEMPLATE_ID = "TEMPLATE_ID";
        String COLUMN_TEMPLATE_TYPE = "TEMPLATE_TYPE";
        String COLUMN_REQUIRES_NON_MARKET_INSTALL = "requires_non_market_install";
        String COLUMN_AD_MARKET_ID = "ad_market_id";
        String COLUMN_BID_TOKEN = "bid_token";
        String COLUMN_PLACEMENT_ID = "placement_id";
        String COLUMN_STATE = "state";
        String COLUMN_CACHEABLE_ASSETS = "cacheable_assets";
        String COLUMN_TT_DOWNLOAD = "tt_download";
        String COLUMN_ASSET_DOWNLOAD_TIMESTAMP = "asset_download_timestamp";
        String COLUMN_ASSET_DOWNLOAD_DURATION = "asset_download_duration";
        String COLUMN_AD_REQUEST_START_TIMESTAMP = "ad_request_start_time";
        String COLUMN_ENABLE_OM_SDK = "column_enable_om_sdk";
        String COLUMN_OM_SDK_EXTRA_VAST = "column_om_sdk_extra_vast";
        String COLUMN_SERVER_REQUEST_TIMESTAMP = "column_request_timestamp";
        String COLUMN_CLICK_COORDINATES_ENABLED = "column_click_coordinates_enabled";
        String COLUMN_ASSETS_FULLY_DOWNLOADED = "column_assets_fully_downloaded";
        String COLUMN_DEEP_LINK = "column_deep_link";
        String COLUMN_NOTIFICATIONS = "column_notifications";
        String COLUMN_HEADER_BIDDING = "column_header_bidding";

    }

    public static final String CREATE_ADVERTISEMENT_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS "
            + AdvertisementDBAdapter.AdvertisementColumns.TABLE_NAME
            + "("
            + AdvertisementDBAdapter.AdvertisementColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT,  "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_IDENTIFIER + " TEXT UNIQUE, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_AD_CONFIG + " TEXT,"//Json
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_AD_TYPE + " INT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_EXPIRE_TIME + " NUMERIC, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_DELAY + " NUMERIC, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_SHOW_CLOSE_DELAY + " INT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_SHOW_CLOSE_INCENTIVISED + " INT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_COUNTDOWN + " INT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_VIDEO_HEIGHT + " INT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_VIDEO_WIDTH + " INT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CTA_OVERLAY_ENABLED + " SHORT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CTA_CLICK_AREA + " NUMERIC, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_RETRY_COUNT + " INT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_REQUIRES_NON_MARKET_INSTALL + " SHORT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_APP_ID + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CAMPAIGN + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_VIDEO_URL + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_MD5 + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_POSTROLL_BUNDLE_URL + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CTA_DESTINATION_URL + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CTA_URL + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_AD_TOKEN + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_VIDEO_IDENTIFIER + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_TEMPLATE_URL + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_TEMPLATE_ID + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_TEMPLATE_TYPE + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_AD_MARKET_ID + " TEXT,"
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_BID_TOKEN + " TEXT,  "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CHECKPOINTS + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_TEMPLATE_SETTINGS + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_MRAID_FILES + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CACHEABLE_ASSETS + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_STATE + " INT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_PLACEMENT_ID + " TEXT, "
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_TT_DOWNLOAD + " NUMERIC,"
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_ASSET_DOWNLOAD_TIMESTAMP + " NUMERIC,"
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_ASSET_DOWNLOAD_DURATION + " NUMERIC,"
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_AD_REQUEST_START_TIMESTAMP + " NUMERIC,"
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_ENABLE_OM_SDK + " SHORT,"
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_OM_SDK_EXTRA_VAST + " TEXT,"
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_SERVER_REQUEST_TIMESTAMP + " NUMERIC,"
            + AdvertisementDBAdapter.AdvertisementColumns.COLUMN_CLICK_COORDINATES_ENABLED + " SHORT,"
            + AdvertisementColumns.COLUMN_DYNAMIC_EVENTS_AND_URLS + " TEXT, "
            + AdvertisementColumns.COLUMN_DEEP_LINK + " TEXT, "
            + AdvertisementColumns.COLUMN_NOTIFICATIONS + " TEXT, "
            + AdvertisementColumns.COLUMN_ASSETS_FULLY_DOWNLOADED + " SHORT, "
            + AdvertisementColumns.COLUMN_HEADER_BIDDING + " SHORT"
            + ")";
}
