package com.vungle.warren.model;

import android.content.ContentValues;

import androidx.annotation.NonNull;

import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;

public class AnalyticUrlDBAdapter implements DBAdapter<AnalyticUrl> {
    @Override
    public ContentValues toContentValues(AnalyticUrl item) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(AnalyticUrlDBAdapter.AnalyticsUrlColumns.COLUMN_IDENTIFIER, item.url);
        return contentValues;
    }

    @NonNull
    @Override
    public AnalyticUrl fromContentValues(ContentValues values) {
        String url  = values.getAsString(AnalyticUrlDBAdapter.AnalyticsUrlColumns.COLUMN_IDENTIFIER);
        AnalyticUrl item = new AnalyticUrl(url);
        return item;
    }

    @Override
    public String tableName() {
        return AnalyticsUrlColumns.TABLE_NAME;
    }

    public interface AnalyticsUrlColumns extends IdColumns {
        String TABLE_NAME = "analytic_url";
    }

    /**
     * Using columnn_identifier to hold unique url
     */
    public static final String CREATE_ANALYTICS_URL_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS "
            + AnalyticUrlDBAdapter.AnalyticsUrlColumns.TABLE_NAME
            + "("
            + AnalyticUrlDBAdapter.AnalyticsUrlColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT,  "
            + AnalyticUrlDBAdapter.AnalyticsUrlColumns.COLUMN_IDENTIFIER + " TEXT UNIQUE"
            + ")";
}
