package com.vungle.warren.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.vungle.warren.model.token.Consent;
import com.vungle.warren.model.token.Device;
import com.vungle.warren.model.token.Request;

public class BidTokenV3 {

    public BidTokenV3(Device device, Request request, Consent consent) {
        this.device = device;
        this.request = request;
        this.consent = consent;
    }

    @SerializedName("device")
    @Expose
    private Device device;
    @SerializedName("request")
    @Expose
    private Request request;
    @SerializedName("consent")
    @Expose
    private Consent consent;


    public Request getRequest() {
        return request;
    }

    public Consent getConsent() {
        return consent;
    }

    public Device getDevice() {
        return device;
    }
}


