package com.vungle.warren.model;

import android.content.ContentValues;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;

import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;

/**
 * @author Blashchuk Anton
 */
public class CacheBustDBAdapter implements DBAdapter<CacheBust> {

    @VisibleForTesting
    static final String DELIMITER = ";";

    @Override
    public ContentValues toContentValues(CacheBust item) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(CacheBustColumns.COLUMN_IDENTIFIER, item.calculateId());
        contentValues.put(CacheBustColumns.COLUMN_EVENT_ID, item.id);
        contentValues.put(CacheBustColumns.COLUMN_TIME_WINDOW_END, item.timeWindowEnd);

        contentValues.put(CacheBustColumns.COLUMN_EVENT_ID_TYPE, item.idType);
        contentValues.put(CacheBustColumns.COLUMN_EVENT_IDS, arrayToString(item.eventIds));
        contentValues.put(CacheBustColumns.COLUMN_TIMESTAMP_PROCESSED, item.timestampProcessed);

        return contentValues;
    }

    @NonNull
    @Override
    public CacheBust fromContentValues(ContentValues values) {
        CacheBust item = new CacheBust();
        item.id = values.getAsString(CacheBustColumns.COLUMN_EVENT_ID);
        item.timeWindowEnd = values.getAsLong(CacheBustColumns.COLUMN_TIME_WINDOW_END);

        item.idType = values.getAsInteger(CacheBustColumns.COLUMN_EVENT_ID_TYPE);
        item.eventIds = stringToArray(values.getAsString(CacheBustColumns.COLUMN_EVENT_IDS));
        item.timestampProcessed = values.getAsLong(CacheBustColumns.COLUMN_TIMESTAMP_PROCESSED);

        return item;
    }

    @Override
    public String tableName() {
        return CacheBustColumns.TABLE_NAME;
    }


    public interface CacheBustColumns extends IdColumns {
        String TABLE_NAME = "cache_bust";
        String COLUMN_EVENT_ID = "id";
        String COLUMN_TIME_WINDOW_END = "time_window_end";

        String COLUMN_EVENT_ID_TYPE = "id_type";
        String COLUMN_EVENT_IDS = "event_ids";
        String COLUMN_TIMESTAMP_PROCESSED = "timestamp_processed";
    }

    public static final String CREATE_CACHE_BUST_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS "
            + CacheBustColumns.TABLE_NAME
            + "("
            + CacheBustColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT, "
            + CacheBustColumns.COLUMN_IDENTIFIER + " TEXT UNIQUE, "
            + CacheBustColumns.COLUMN_EVENT_ID + " TEXT, "
            + CacheBustColumns.COLUMN_TIME_WINDOW_END + " INTEGER, "
            + CacheBustColumns.COLUMN_EVENT_ID_TYPE + " INTEGER, "
            + CacheBustColumns.COLUMN_EVENT_IDS + " TEXT, "
            + CacheBustColumns.COLUMN_TIMESTAMP_PROCESSED + " INTEGER "
            + ")";

    static String arrayToString(String[] array) {
        if (array == null || array.length == 0) {
            return "";
        } else if (array.length == 1) {
            return array[0];
        } else {
            StringBuilder result = new StringBuilder(array[0]);
            for (int i = 1; i < array.length; i++) {
                result.append(DELIMITER).append(array[i]);
            }
            return result.toString();
        }
    }

    static String[] stringToArray(String string) {
        if (string.isEmpty()) return new String[0];
        return string.split(DELIMITER);
    }
}
