package com.vungle.warren.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

import androidx.annotation.Nullable;

public class JsonUtil {

    public static boolean hasNonNull(@Nullable JsonElement jsonElement, String key) {
        if (jsonElement == null || jsonElement.isJsonNull() || !jsonElement.isJsonObject())
            return false;

        JsonObject object = jsonElement.getAsJsonObject();
        return object.has(key) && object.get(key) != null && !object.get(key).isJsonNull();
    }

    public static boolean getAsBoolean(@Nullable JsonElement jsonElement, String key, boolean defaultValue) {
        if (hasNonNull(jsonElement, key)) {
            JsonObject object = jsonElement.getAsJsonObject();
            return object.get(key).getAsBoolean();
        } else {
            return defaultValue;
        }
    }

    public static String getAsString(@Nullable JsonElement jsonElement, String key, String defaultValue) {
        if (hasNonNull(jsonElement, key)) {
            JsonObject object = jsonElement.getAsJsonObject();
            return object.get(key).getAsString();
        } else {
            return defaultValue;
        }
    }

    public static int getAsInt(@Nullable JsonElement jsonElement, String key, int defaultValue) {
        if (hasNonNull(jsonElement, key)) {
            JsonObject object = jsonElement.getAsJsonObject();
            return object.get(key).getAsInt();
        } else {
            return defaultValue;
        }
    }

    @Nullable
    public static JsonObject getAsObject(@Nullable JsonElement jsonElement, String key) {
        if (hasNonNull(jsonElement, key)) {
            JsonObject object = jsonElement.getAsJsonObject();
            return object.get(key).getAsJsonObject();
        } else {
            return null;
        }
    }

}
