package com.vungle.warren.model;

import android.content.ContentValues;
import androidx.annotation.NonNull;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

import static com.vungle.warren.persistence.ContentValuesUtil.getBoolean;

public class ReportDBAdapter implements DBAdapter<Report> {

    private Gson gson = new GsonBuilder().create();
    Type stringType = new TypeToken<ArrayList<String>>() {
    }.getType();
    Type userActionsType = new TypeToken<ArrayList<Report.UserAction>>() {
    }.getType();

    @Override
    public ContentValues toContentValues(Report item) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(ReportColumns.COLUMN_IDENTIFIER, item.getId());
        contentValues.put(ReportColumns.COLUMN_AD_DURATION, item.adDuration);
        contentValues.put(ReportColumns.COLUMN_AD_START_TIME, item.adStartTime);
        contentValues.put(ReportColumns.COLUMN_AD_TOKEN, item.adToken);
        contentValues.put(ReportColumns.COLUMN_AD_TYPE, item.adType);
        contentValues.put(ReportColumns.COLUMN_APP_ID, item.appId);
        contentValues.put(ReportColumns.COLUMN_CAMPAIGN, item.campaign);
        contentValues.put(ReportColumns.COLUMN_INCENTIVIZED, item.incentivized);
        contentValues.put(ReportColumns.COLUMN_HEADERBIDDING, item.headerBidding);
        contentValues.put(ReportColumns.COLUMN_ORDINAL, item.ordinal);
        contentValues.put(ReportColumns.COLUMN_PLACEMENT_ID, item.placementId);
        contentValues.put(ReportColumns.COLUMN_TEMPATE_ID, item.templateId);
        contentValues.put(ReportColumns.COLUMN_TT_DOWNLOAD, item.ttDownload);
        contentValues.put(ReportColumns.COLUMN_URL, item.url);
        contentValues.put(ReportColumns.COLUMN_USER_ID, item.userID);
        contentValues.put(ReportColumns.COLUMN_VIDEO_LENGTH, item.videoLength);
        contentValues.put(ReportColumns.COLUMN_VIDEO_VIEWED, item.videoViewed);
        contentValues.put(ReportColumns.COLUMN_WAS_CTA_CLICKED, item.wasCTAClicked);
        contentValues.put(ReportColumns.COLUMN_USER_ACTIONS, gson.toJson(new ArrayList<>(item.userActions), userActionsType));
        contentValues.put(ReportColumns.COLUMN_CLICKED_THROUGH, gson.toJson(new ArrayList<>(item.clickedThrough), stringType));
        contentValues.put(ReportColumns.COLUMN_ERRORS, gson.toJson(new ArrayList<>(item.errors), stringType));
        contentValues.put(ReportColumns.COLUMN_REPORT_STATUS, item.status);
        contentValues.put(ReportColumns.COLUMN_AD_SIZE, item.adSize);
        contentValues.put(ReportColumns.COLUMN_INIT_TIMESTAMP, item.initTimeStamp);
        contentValues.put(ReportColumns.COLUMN_ASSET_DOWNLOAD_DURATION, item.assetDownloadDuration);
        contentValues.put(ReportColumns.COLUMN_PLAY_REMOTE_URL, item.playRemoteUrl);

        return contentValues;
    }

    @NonNull
    @Override
    public Report fromContentValues(ContentValues values) {
        Report item = new Report();
//        generated
//        contentValues.put(ReportColumns.COLUMN_IDENTIFIER, item.getId());
        item.adDuration = values.getAsLong(ReportColumns.COLUMN_AD_DURATION);
        item.adStartTime = values.getAsLong(ReportColumns.COLUMN_AD_START_TIME);
        item.adToken = values.getAsString(ReportColumns.COLUMN_AD_TOKEN);
        item.adType = values.getAsString(ReportColumns.COLUMN_AD_TYPE);
        item.appId = values.getAsString(ReportColumns.COLUMN_APP_ID);
        item.campaign = values.getAsString(ReportColumns.COLUMN_CAMPAIGN);
        item.ordinal = values.getAsInteger(ReportColumns.COLUMN_ORDINAL);
        item.placementId = values.getAsString(ReportColumns.COLUMN_PLACEMENT_ID);
        item.templateId = values.getAsString(ReportColumns.COLUMN_TEMPATE_ID);
        item.ttDownload = values.getAsLong(ReportColumns.COLUMN_TT_DOWNLOAD);
        item.url = values.getAsString(ReportColumns.COLUMN_URL);
        item.userID = values.getAsString(ReportColumns.COLUMN_USER_ID);
        item.videoLength = values.getAsLong(ReportColumns.COLUMN_VIDEO_LENGTH);
        item.videoViewed = values.getAsInteger(ReportColumns.COLUMN_VIDEO_VIEWED);

        item.wasCTAClicked =  getBoolean(values, ReportColumns.COLUMN_WAS_CTA_CLICKED);
        item.incentivized = getBoolean(values, ReportColumns.COLUMN_INCENTIVIZED);
        item.headerBidding = getBoolean(values, ReportColumns.COLUMN_HEADERBIDDING);
        item.status = values.getAsInteger(ReportColumns.COLUMN_REPORT_STATUS);
        item.adSize = values.getAsString(ReportColumns.COLUMN_AD_SIZE);

        item.initTimeStamp = values.getAsLong(ReportColumns.COLUMN_INIT_TIMESTAMP);
        item.assetDownloadDuration = values.getAsLong(ReportColumns.COLUMN_ASSET_DOWNLOAD_DURATION);
        item.playRemoteUrl = getBoolean(values, ReportColumns.COLUMN_PLAY_REMOTE_URL);

        List<String> clicks = gson.fromJson(values.getAsString(ReportColumns.COLUMN_CLICKED_THROUGH), stringType);
        List<String> errors = gson.fromJson(values.getAsString(ReportColumns.COLUMN_ERRORS), stringType);
        List<Report.UserAction> userActions = gson.fromJson(values.getAsString(ReportColumns.COLUMN_USER_ACTIONS), userActionsType);

        if (clicks != null) item.clickedThrough.addAll(clicks);
        if (errors != null) item.errors.addAll(errors);
        if (userActions != null) item.userActions.addAll(userActions);

        return item;
    }

    @Override
    public String tableName() {
        return ReportColumns.TABLE_NAME;
    }

    public interface ReportColumns extends IdColumns {
        String TABLE_NAME = "report";

        String COLUMN_PLACEMENT_ID = "placementId";
        String COLUMN_AD_TOKEN = "adToken";
        String COLUMN_APP_ID = "appId";
        String COLUMN_INCENTIVIZED = "incentivized";
        String COLUMN_HEADERBIDDING = "header_bidding";
        String COLUMN_AD_START_TIME = "adStartTime";
        String COLUMN_URL = "url";
        String COLUMN_AD_DURATION = "ad_duration";
        String COLUMN_TT_DOWNLOAD = "tt_download";
        String COLUMN_CAMPAIGN = "campaign";
        String COLUMN_VIDEO_VIEWED = "videoViewed";
        String COLUMN_AD_TYPE = "ad_type";
        String COLUMN_TEMPATE_ID = "template_id";
        String COLUMN_WAS_CTA_CLICKED = "was_CTAC_licked";
        String COLUMN_CLICKED_THROUGH = "clicked_through";
        String COLUMN_ERRORS = "errors";
        String COLUMN_USER_ACTIONS = "user_actions";
        String COLUMN_USER_ID = "user_id";
        String COLUMN_ORDINAL = "ordinal";
        String COLUMN_VIDEO_LENGTH = "videoLength";
        String COLUMN_REPORT_STATUS = "status";
        String COLUMN_AD_SIZE = "ad_size";
        String COLUMN_INIT_TIMESTAMP = "init_timestamp";
        String COLUMN_ASSET_DOWNLOAD_DURATION = "asset_download_duration";
        String COLUMN_PLAY_REMOTE_URL = "play_remote_url";
    }

    public static final String CREATE_REPORT_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS "
            + ReportDBAdapter.ReportColumns.TABLE_NAME
            + "("
            + ReportDBAdapter.ReportColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT, "
            + ReportDBAdapter.ReportColumns.COLUMN_IDENTIFIER + " TEXT UNIQUE,"
            + ReportDBAdapter.ReportColumns.COLUMN_APP_ID + " TEXT, "
            + ReportDBAdapter.ReportColumns.COLUMN_PLACEMENT_ID + " TEXT, "
            + ReportDBAdapter.ReportColumns.COLUMN_AD_TOKEN + " TEXT, "
            + ReportDBAdapter.ReportColumns.COLUMN_INCENTIVIZED + " SHORT, "
            + ReportDBAdapter.ReportColumns.COLUMN_HEADERBIDDING + " SHORT, "
            + ReportDBAdapter.ReportColumns.COLUMN_AD_START_TIME + " NUMERIC, "
            + ReportDBAdapter.ReportColumns.COLUMN_URL + " TEXT, "
            + ReportDBAdapter.ReportColumns.COLUMN_AD_DURATION + " NUMERIC, "
            + ReportDBAdapter.ReportColumns.COLUMN_TT_DOWNLOAD + " NUMERIC, "
            + ReportDBAdapter.ReportColumns.COLUMN_CAMPAIGN + " TEXT, "
            + ReportDBAdapter.ReportColumns.COLUMN_VIDEO_VIEWED + " NUMERIC, "
            + ReportDBAdapter.ReportColumns.COLUMN_AD_TYPE + " TEXT, "
            + ReportDBAdapter.ReportColumns.COLUMN_TEMPATE_ID + " TEXT, "
            + ReportDBAdapter.ReportColumns.COLUMN_WAS_CTA_CLICKED + " SHORT, "
            + ReportDBAdapter.ReportColumns.COLUMN_CLICKED_THROUGH + " TEXT, "
            + ReportDBAdapter.ReportColumns.COLUMN_ERRORS + " TEXT, "
            + ReportDBAdapter.ReportColumns.COLUMN_USER_ACTIONS + " TEXT, "
            + ReportDBAdapter.ReportColumns.COLUMN_USER_ID + " TEXT, "
            + ReportDBAdapter.ReportColumns.COLUMN_ORDINAL + " INT, "
            + ReportDBAdapter.ReportColumns.COLUMN_VIDEO_LENGTH + " NUMERIC, "
            + ReportDBAdapter.ReportColumns.COLUMN_REPORT_STATUS + " INT, "
            + ReportDBAdapter.ReportColumns.COLUMN_AD_SIZE + " TEXT, "
            + ReportDBAdapter.ReportColumns.COLUMN_INIT_TIMESTAMP + " NUMERIC, "
            + ReportDBAdapter.ReportColumns.COLUMN_ASSET_DOWNLOAD_DURATION + " NUMERIC,"
            + ReportDBAdapter.ReportColumns.COLUMN_PLAY_REMOTE_URL + " SHORT "
            + ")";

}
