package com.vungle.warren.model;

import android.content.ContentValues;

import androidx.annotation.NonNull;

import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;

public class SessionDataDBAdapter implements DBAdapter<SessionData> {

    @Override
    public ContentValues toContentValues(SessionData item) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(SessionDataColumns.COLUMN_IDENTIFIER, item.getId());
        contentValues.put(SessionDataColumns.JSON_STRING, item.getAsJsonString());
        contentValues.put(SessionDataColumns.SEND_ATTEMPTS, item.getSendAttempts());
        return contentValues;
    }

    @NonNull
    @Override
    public SessionData fromContentValues(ContentValues values) {
        SessionData item = new SessionData(
                values.getAsString(SessionDataColumns.JSON_STRING),
                values.getAsInteger(SessionDataColumns.SEND_ATTEMPTS));
        return item;
    }

    @Override
    public String tableName() {
        return SessionDataColumns.TABLE_NAME;
    }

    public interface SessionDataColumns extends IdColumns {
        String TABLE_NAME = "session_data";

        String JSON_STRING = "json_string";
        String SEND_ATTEMPTS = "send_attempts";
    }

    public static final String CREATE_SESSION_DATA_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS "
            + SessionDataColumns.TABLE_NAME
            + "("
            + SessionDataColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT, "
            + SessionDataColumns.COLUMN_IDENTIFIER + " TEXT UNIQUE,"
            + SessionDataColumns.JSON_STRING + " TEXT, "
            + SessionDataColumns.SEND_ATTEMPTS + " INT"
            + ")";

}
