package com.vungle.warren.model;

public class VisionData {

    public long timestamp;

    public String creative;

    public String campaign;

    public String advertiser;

    public VisionData(long timestamp, String creative, String campaign, String advertiser) {
        this.timestamp = timestamp;
        this.creative = creative;
        this.campaign = campaign;
        this.advertiser = advertiser;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        VisionData data = (VisionData) o;

        if (timestamp != data.timestamp) return false;
        if (creative != null ? !creative.equals(data.creative) : data.creative != null)
            return false;
        if (campaign != null ? !campaign.equals(data.campaign) : data.campaign != null)
            return false;
        return advertiser != null ? advertiser.equals(data.advertiser) : data.advertiser == null;
    }

    @Override
    public int hashCode() {
        int result = (int) (timestamp ^ (timestamp >>> 32));
        result = 31 * result + (creative != null ? creative.hashCode() : 0);
        result = 31 * result + (campaign != null ? campaign.hashCode() : 0);
        result = 31 * result + (advertiser != null ? advertiser.hashCode() : 0);
        return result;
    }
}
