package com.vungle.warren.model.admarkup;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.vungle.warren.model.JsonUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

import androidx.annotation.Nullable;

public final class AdMarkupV1 extends AdMarkup implements Serializable {
    private final String eventId;


    private AdMarkupV1(String eventId, String[] impressions) {
        this.eventId = eventId;
        this.impressions = impressions;
    }

    @Override
    public String getEventId() {
        return eventId;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public String toString() {
        return "    AdMarkup {" +
                "eventId='" + eventId + '\'' +
                ", impression=" + Arrays.toString(impressions) +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AdMarkupV1 adMarkup = (AdMarkupV1) o;

        return eventId != null ? eventId.equals(adMarkup.eventId) : adMarkup.eventId == null;
    }

    @Override
    public int hashCode() {
        return eventId != null ? eventId.hashCode() : 0;
    }

    @Nullable
    public static AdMarkupV1 fromString(String string) {
        if (string == null) {
            return null;
        }
        JsonObject jsonObject;
        try {
            jsonObject = new GsonBuilder().create().fromJson(string, JsonObject.class);
        } catch (JsonSyntaxException ignored) {
            return null;
        }
        if (jsonObject == null) {
            return null;
        }

        ArrayList<String> impression = null;
        if (JsonUtil.hasNonNull(jsonObject, "impression")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("impression");
            if (jsonArray.isJsonArray()) {
                impression = new ArrayList<>();
                for (JsonElement element : jsonArray.getAsJsonArray()) {
                    impression.add(element.getAsString());
                }
            }
        }
        return new AdMarkupV1(
                JsonUtil.getAsString(jsonObject, "event_id", null),
                impression != null ? impression.toArray(new String[]{}) : null);
    }
}
