package com.vungle.warren.model.admarkup;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.vungle.warren.model.Advertisement;

import java.io.Serializable;

import androidx.annotation.NonNull;

public class AdMarkupV2 extends AdMarkup implements Serializable {

    private final String advertisementJsonObject;
    private final String placementId;

    public AdMarkupV2(JsonObject json, String[] impressions) {
        this.impressions = impressions;

        JsonArray jsonArray = json.getAsJsonArray("ads");
        JsonElement e = jsonArray.get(0);

        placementId = e.getAsJsonObject().get("placement_reference_id").getAsString();
        advertisementJsonObject = e.getAsJsonObject().toString();
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public String getEventId() {
        return getAdvertisement().getId();
    }

    public @NonNull Advertisement getAdvertisement() {
        JsonObject jsonObject = JsonParser.parseString(advertisementJsonObject).getAsJsonObject();
        Advertisement ad = new Advertisement(jsonObject);
        ad.setPlacementId(placementId);
        ad.setHeaderBidding(true);
        return ad;
    }
}
