package com.vungle.warren.model.token;

import android.os.Build;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.vungle.warren.BuildConfig;

public class Device {

    @SerializedName("battery_saver_enabled")
    @Expose
    private Boolean batterySaverEnabled;
    @SerializedName("language")
    @Expose
    private String language;
    @SerializedName("time_zone")
    @Expose
    private String timezone;
    @SerializedName("volume_level")
    @Expose
    private Double volumeLevel;
    @SerializedName("ifa")
    @Expose
    private String ifa;

    @SerializedName("amazon")
    @Expose
    private AndroidInfo amazon;

    @SerializedName("android")
    @Expose
    private AndroidInfo android;

    @SerializedName("extension")
    @Expose
    private Extension extension;

    public Device(Boolean batterySaverEnabled, String language, String timezone, Double volumeLevel,
                  String ifa, AndroidInfo amazon, AndroidInfo android, Extension extension) {
        this.batterySaverEnabled = batterySaverEnabled;
        this.language = language;
        this.timezone = timezone;
        this.volumeLevel = volumeLevel;
        this.ifa = ifa;
        this.amazon = amazon;
        this.android = android;
        this.extension = extension;
    }
}
