package com.vungle.warren.model.token;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

import androidx.annotation.StringDef;

public class Gdpr {

    @SerializedName("status")
    @Expose
    private String status;
    @SerializedName("source")
    @Expose
    private String source;
    @SerializedName("message_version")
    @Expose
    private String messageVersion;
    @SerializedName("timestamp")
    @Expose
    private Long timestamp;

    public static final String OPTED_IN = "opted_in";
    public static final String OPTED_OUT = "opted_out";
    public static final String OPTED_OUT_BY_TIMEOUT = "opted_out_by_timeout";
    public static final String UNKNOWN = "unknown";


    @Retention(RetentionPolicy.SOURCE)
    @StringDef({OPTED_IN, OPTED_OUT, UNKNOWN, OPTED_OUT_BY_TIMEOUT})
    public @interface Status {
    }

    public String getStatus() {
        return status;
    }

    public String getSource() {
        return source;
    }

    public String getMessageVersion() {
        return messageVersion;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public Gdpr(String status, String source, String messageVersion, Long timestamp) {
        this.status = status;
        this.source = source;
        this.messageVersion = messageVersion;
        this.timestamp = timestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Gdpr gdpr = (Gdpr) o;
        return status.equals(gdpr.status) &&
                source.equals(gdpr.source) &&
                messageVersion.equals(gdpr.messageVersion) &&
                timestamp.equals(gdpr.timestamp);
    }

}