package com.vungle.warren.network;

import java.util.List;

import androidx.annotation.NonNull;
import okhttp3.Call;
import okhttp3.HttpUrl;

public class APIFactory {

    private static final String TAG = APIFactory.class.getSimpleName();

    private Call.Factory okHttpClient;
    private HttpUrl baseUrl;

    public APIFactory(@NonNull Call.Factory callFactory, @NonNull String baseUrl) {
        this.baseUrl = HttpUrl.get(baseUrl);
        this.okHttpClient = callFactory;

        List<String> pathSegments = this.baseUrl.pathSegments();
        if (!"".equals(pathSegments.get(pathSegments.size() - 1))) {
            throw new IllegalArgumentException("baseUrl must end in /: " + baseUrl);
        }
    }

    @NonNull
    public VungleApi createAPI(String appId) {
        VungleApiImpl vungleApi = new VungleApiImpl(baseUrl, okHttpClient);
        vungleApi.setAppId(appId);
        return vungleApi;
    }

}
