package com.vungle.warren.omsdk;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;

import com.iab.omid.library.vungle.Omid;
import com.vungle.warren.SessionTracker;
import com.vungle.warren.model.SessionData;
import com.vungle.warren.session.SessionAttribute;
import com.vungle.warren.session.SessionEvent;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;

public class OMInjector {
    private static final String OM_SDK_JS = "omsdk.js";
    private static final String OM_SESSION_JS = "omsdk-session.js";

    private Handler uiHandler = new Handler(Looper.getMainLooper());
    private AtomicReference<Context> contextRef;

    public OMInjector(Context context) {
        contextRef = new AtomicReference<>(context.getApplicationContext());
    }

    public void init() {
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                if (!Omid.isActive()) {
                    Omid.activate(contextRef.get());
                    SessionTracker.getInstance().trackEvent(
                            new SessionData.Builder()
                                    .setEvent(SessionEvent.OM_SDK)
                                    .addData(SessionAttribute.ENABLED, true)
                                    .addData(SessionAttribute.SUCCESS, Omid.isActive())
                                    .build()
                    );
                }
            }
        });
    }

    @WorkerThread
    @NonNull
    public List<File> injectJsFiles(@NonNull File dir) throws IOException {
        ArrayList<File> list = new ArrayList<>();
        list.add(writeToFile(Res.OM_JS, new File(dir, OM_SDK_JS)));
        list.add(writeToFile(Res.OM_SESSION_JS, new File(dir, OM_SESSION_JS)));
        return list;
    }

    private File writeToFile(String lines, File outputFile) throws IOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(outputFile);
            writer.write(lines);
            writer.flush();
        } finally {
            closeQuietly(writer);
        }
        return outputFile;
    }

    private void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null)
                closeable.close();
        } catch (IOException ignored) {
        }
    }
}
