package com.vungle.warren.omsdk;

import android.webkit.WebView;

import com.iab.omid.library.vungle.Omid;
import com.iab.omid.library.vungle.adsession.AdSession;
import com.iab.omid.library.vungle.adsession.AdSessionConfiguration;
import com.iab.omid.library.vungle.adsession.AdSessionContext;
import com.iab.omid.library.vungle.adsession.CreativeType;
import com.iab.omid.library.vungle.adsession.ImpressionType;
import com.iab.omid.library.vungle.adsession.Owner;
import com.iab.omid.library.vungle.adsession.Partner;
import com.vungle.warren.BuildConfig;

import java.util.concurrent.TimeUnit;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;

public class OMTracker implements WebViewObserver {
    public static class Factory {
        public OMTracker make(boolean enabled) {
            return new OMTracker(enabled);
        }
    }

    @VisibleForTesting
    static final long DESTROY_DELAY_MS = TimeUnit.SECONDS.toMillis(1);
    private final boolean enabled;
    private boolean started;

    private AdSession adSession;
    private OMTracker(boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * Starts OM session
     */
    public void start() {
        if (enabled && Omid.isActive()) {
            started = true;
        }
    }

    /**
     * Stops OM session
     * @return timeout when {@link WebView} can be destroyed
     */
    public long stop() {
        long delay = 0L;
        if (started && adSession != null) {
            adSession.finish();
            delay = DESTROY_DELAY_MS;
        }
        started = false;
        adSession = null;
        return delay;
    }

    @Override
    public void onPageFinished(@NonNull WebView webView) {
        if (started && adSession == null) {
            AdSessionConfiguration adSessionConfiguration =
                    AdSessionConfiguration.createAdSessionConfiguration(
                            CreativeType.DEFINED_BY_JAVASCRIPT,
                            ImpressionType.DEFINED_BY_JAVASCRIPT,
                            Owner.JAVASCRIPT,
                            Owner.JAVASCRIPT,
                            false);
            Partner partner = Partner.createPartner(BuildConfig.OMSDK_PARTNER_NAME, BuildConfig.VERSION_NAME);
            AdSessionContext adSessionContext = AdSessionContext.createHtmlAdSessionContext(partner, webView, null, null);
            adSession = AdSession.createAdSession(adSessionConfiguration, adSessionContext);

            adSession.registerAdView(webView);
            adSession.start();
        }
    }
}
