package com.vungle.warren.session;

/**
 * Session Events
 */
public enum SessionEvent {
    INIT,
    INIT_END,
    PLAY_AD,
    APP_FOREGROUND,
    APP_BACKGROUND,
    AD_EXPIRED,
    LOAD_AD,
    LOAD_AD_END,
    AD_AVAILABLE,

    // If setAndroidIdOptOut API used
    ANDROID_ID,

    // whether video assets where used
    ADS_CACHED,
    ORIENTATION,
    MUTE,
    REWARDED,

    // OM_SDK success or failure
    OM_SDK,

    // Close ad callback
    DID_CLOSE,

    // Track when banner ads are dismissed by API
    DISMISS_AD,

    // Track only failures to send TPATS
    TPAT;

    @Override
    public String toString() {
        return super.toString().toLowerCase();
    }

}
