package com.vungle.warren.tasks;

import android.os.Bundle;
import androidx.annotation.IntDef;
import androidx.annotation.NonNull;
import android.util.Log;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class JobInfo implements Cloneable {

    private static final String TAG = "JobInfo";

    private final String tag;

    private boolean updateCurrent;

    private long delay;
    private long rescheduleTimeout;
    private long nextRescheduleTimeout;

    private Bundle extras = new Bundle();

    @ReschedulePolicy
    private int reschedulePolicy = ReschedulePolicy.EXPONENTIAL;

    @Priority
    private int priority = Priority.NORMAL;

    @NetworkType
    private int requiredNetworkType = NetworkType.ANY;

    public JobInfo(@NonNull String tag) {
        this.tag = tag;
    }

    public JobInfo setUpdateCurrent(boolean updateCurrent) {
        this.updateCurrent = updateCurrent;
        return this;
    }

    public JobInfo setExtras(@NonNull Bundle extras) {
        if (extras != null) {
            this.extras = extras;
        }

        return this;
    }

    public JobInfo setDelay(long delay) {
        this.delay = delay;
        return this;
    }

    public JobInfo setReschedulePolicy(long rescheduleTimeout, @ReschedulePolicy int delayCriteria) {
        this.rescheduleTimeout = rescheduleTimeout;
        this.reschedulePolicy = delayCriteria;
        return this;
    }

    public JobInfo setPriority(@Priority int priority) {
        this.priority = priority;
        return this;
    }

    public String getJobTag() {
        return tag;
    }

    public Bundle getExtras() {
        return extras;
    }

    public long getDelay() {
        return delay;
    }

    public long makeNextRescedule() {
        if (rescheduleTimeout == 0) return 0;

        if (nextRescheduleTimeout == 0) {
            nextRescheduleTimeout = rescheduleTimeout;
        } else if (reschedulePolicy == ReschedulePolicy.EXPONENTIAL) {
            nextRescheduleTimeout = nextRescheduleTimeout * 2;
        }

        return nextRescheduleTimeout;
    }

    public boolean getUpdateCurrent() {
        return updateCurrent;
    }

    public int getPriority() {
        return priority;
    }

    public JobInfo copy() {
        try {
            return (JobInfo) super.clone();
        } catch (CloneNotSupportedException e) {
            Log.e(TAG, Log.getStackTraceString(e));
        }

        return null;
    }

    public int getRequiredNetworkType() {
        return requiredNetworkType;
    }

    public JobInfo setRequiredNetworkType(@NetworkType int requiredNetworkType) {
        this.requiredNetworkType = requiredNetworkType;
        return this;
    }

    @IntDef(value = {ReschedulePolicy.LINEAR, ReschedulePolicy.EXPONENTIAL})
    @Retention(RetentionPolicy.SOURCE)
    public @interface ReschedulePolicy {
        int LINEAR = 0;
        int EXPONENTIAL = 1;
    }

    @IntDef(value = {Priority.LOWEST, Priority.LOW, Priority.NORMAL, Priority.HIGH, Priority.HIGHEST, Priority.CRITICAL})
    @Retention(RetentionPolicy.SOURCE)
    public @interface Priority {
        int LOWEST = 0;
        int LOW = 1;
        int NORMAL = 2;
        int HIGH = 3;
        int HIGHEST = 4;
        int CRITICAL = 5;
    }

    @IntDef(value = {NetworkType.ANY, NetworkType.CONNECTED})
    public @interface NetworkType {
        int ANY = 0;
        int CONNECTED = 1;
    }
}
