package com.vungle.warren.tasks;

import android.os.Bundle;

import com.vungle.warren.log.LogManager;

public class SendLogsJob implements Job {

    static final String TAG = SendLogsJob.class.getSimpleName();

    private LogManager logManager;

    public SendLogsJob(LogManager logManager) {
        this.logManager = logManager;
    }

    public static JobInfo makeJobInfo() {
        return new JobInfo(TAG)
                .setPriority(JobInfo.Priority.NORMAL);
    }

    @Override
    public int onRunJob(Bundle bundle, JobRunner jobRunner) {
        logManager.sendSdkLogs();
        return Result.SUCCESS;
    }
}
