package com.vungle.warren.tasks;

import android.text.TextUtils;

import com.vungle.warren.AdLoader;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.VungleStaticApi;
import com.vungle.warren.analytics.AdAnalytics;
import com.vungle.warren.log.LogManager;
import com.vungle.warren.persistence.Designer;
import com.vungle.warren.persistence.Repository;

public class VungleJobCreator implements JobCreator {

    private final Repository repository;
    private final Designer designer;
    private final ReconfigJob.ReconfigCall reconfigCall;
    private final VungleApiClient apiClient;
    private final AdAnalytics adAnalytics;
    private final AdLoader adLoader;
    private final VungleStaticApi vungleApi;
    private final LogManager logManager;

    public VungleJobCreator(Repository repository,
                            Designer designer,
                            VungleApiClient apiClient,
                            AdAnalytics adAnalytics,
                            ReconfigJob.ReconfigCall reconfigCall,
                            AdLoader adLoader,
                            VungleStaticApi vungleApi,
                            LogManager logManager) {
        this.repository = repository;
        this.designer = designer;
        this.reconfigCall = reconfigCall;
        this.apiClient = apiClient;
        this.adAnalytics = adAnalytics;
        this.adLoader = adLoader;
        this.vungleApi = vungleApi;
        this.logManager = logManager;
    }

    public Job create(String tag) throws UnknownTagException {

        if (TextUtils.isEmpty(tag)) {
            throw new UnknownTagException("Job tag is null");
        }

        if (tag.startsWith(ReconfigJob.TAG)) {
            return new ReconfigJob(reconfigCall);
        } else if (tag.startsWith(DownloadJob.TAG)) {
            return new DownloadJob(adLoader, vungleApi);
        } else if (tag.startsWith(SendReportsJob.TAG)) {
            return new SendReportsJob(repository, apiClient);
        } else if (tag.startsWith(CleanupJob.TAG)) {
            return new CleanupJob(designer, repository, adLoader);
        } else if (tag.startsWith(AnalyticsJob.TAG)) {
            return new AnalyticsJob(adAnalytics);
        } else if (tag.startsWith(SendLogsJob.TAG)) {
            return new SendLogsJob(logManager);
        } else if (tag.startsWith(CacheBustJob.TAG)) {
            return new CacheBustJob(apiClient, repository, adLoader);
        } else {
            throw new UnknownTagException("Unknown Job Type " + tag);
        }
    }

}
