package com.vungle.warren.tasks.utility;

import android.os.Process;
import androidx.annotation.NonNull;

import com.vungle.warren.tasks.JobInfo;

public class JobRunnerThreadPriorityHelper implements ThreadPriorityHelper {

    private static final String TAG = JobRunnerThreadPriorityHelper.class.getSimpleName();


    @Override
    public int makeAndroidThreadPriority(@NonNull JobInfo jobInfo) {
        int priority = jobInfo.getPriority();
        int delta = Math.min(0, priority - JobInfo.Priority.NORMAL);
        int processPriority = Process.THREAD_PRIORITY_BACKGROUND + Math.abs(delta);
        return Math.min(Process.THREAD_PRIORITY_LOWEST, processPriority);
    }

}
