package com.vungle.warren.ui.contract;

import com.vungle.warren.ui.presenter.NativeAdPresenter;

public interface NativeAdContract {

    interface NativeView extends AdContract.AdView<NativeAdPresenter> {

        boolean isDialogVisible();
    }

    interface NativePresenter extends AdContract.AdvertisementPresenter<NativeView> {

        /**
         * Invoked after CTA/click
         */
        void onDownload();

        /**
         * Invoked on privacy popup being shown
         */
        void onPrivacy();

        void setAdVisibility(boolean isViewable);

        /**
         * Native view is visible and showing the content view
         */
        void onProgressUpdate(int position, float duration);

    }
}
