package com.vungle.warren.ui.contract;

import android.view.MotionEvent;

public interface WebAdContract {
    /**
     * Interface that allows us to define an AdView, whether it be a fragment, Activity, or custom View.
     * This allows our {@link com.vungle.warren.ui.contract.AdContract.AdvertisementPresenter} to render the ad in any
     * container that adheres to this contract.
     */
    interface WebAdView extends AdContract.AdView<WebAdPresenter> {

        /**
         * Updates the window param depending upon its Fulscreen/Interstitial
         * This is applicable only for MRAID ads, for Legacy ads this should be a no-op
         *
         */
        void updateWindow();

        /**
         * Toggle the visibility of Ad container when its ready and loaded for non-fullscreen ads
         * where we render inside a View and where we can avoid showing any residual
         * view elements while its still loading
         */
        void setVisibility(boolean isVisible);

    }

    /**
     * Advertisement Rendering contract. This Presenter interface defines the way that we render advertisements
     * into a view using the {@link com.vungle.warren.model.Advertisement} model.
     */
    interface WebAdPresenter extends AdContract.AdvertisementPresenter<WebAdView> {

        void setAdVisibility(boolean isViewable);

        void onViewTouched(MotionEvent event);

    }
}
