package com.vungle.warren.ui.state;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.HashMap;
import java.util.Map;

public class BundleOptionsState implements OptionsState, Parcelable {

    private Map<String, String> strings = new HashMap<>();
    private Map<String, Boolean> bools = new HashMap<>();
    private Map<String, Integer> ints = new HashMap<>();

    public BundleOptionsState() {
        //Empty
    }

    @Override
    public void put(String key, String value) {
        strings.put(key, value);
    }

    @Override
    public void put(String key, boolean value) {
        bools.put(key, value);
    }

    @Override
    public void put(String key, int value) {
        ints.put(key, value);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        Boolean value = bools.get(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public String getString(String key) {
        return strings.get(key);
    }

    @Override
    public Integer getInt(String key, int defaultValue) {
        Integer value = ints.get(key);
        return value == null ? defaultValue : value;
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.ints.size());
        for (Map.Entry<String, Integer> entry : this.ints.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeValue(entry.getValue());
        }

        dest.writeInt(this.strings.size());
        for (Map.Entry<String, String> entry : this.strings.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeValue(entry.getValue());
        }

        dest.writeInt(this.bools.size());
        for (Map.Entry<String, Boolean> entry : this.bools.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeValue(entry.getValue());
        }
    }


    protected BundleOptionsState(Parcel in) {
        int intsSize = in.readInt();
        for (int i = 0; i < intsSize; i++) {
            String key = in.readString();
            Integer value = (Integer) in.readValue(String.class.getClassLoader());
            this.ints.put(key, value);
        }

        int stringsSize = in.readInt();
        for (int i = 0; i < stringsSize; i++) {
            String key = in.readString();
            String value = (String) in.readValue(String.class.getClassLoader());
            this.strings.put(key, value);
        }

        int boolsSize = in.readInt();
        for (int i = 0; i < boolsSize; i++) {
            String key = in.readString();
            Boolean value = (Boolean) in.readValue(Boolean.class.getClassLoader());
            this.bools.put(key, value);
        }
    }

    public static final Parcelable.Creator<BundleOptionsState> CREATOR = new Parcelable.Creator<BundleOptionsState>() {
        @Override
        public BundleOptionsState createFromParcel(Parcel source) {
            return new BundleOptionsState(source);
        }

        @Override
        public BundleOptionsState[] newArray(int size) {
            return new BundleOptionsState[size];
        }
    };
}
