package com.vungle.warren.ui.view;

import android.content.Context;
import androidx.annotation.NonNull;

import android.view.MotionEvent;
import android.view.View;

import com.vungle.warren.ui.CloseDelegate;
import com.vungle.warren.ui.OrientationDelegate;
import com.vungle.warren.ui.contract.WebAdContract;

/**
 * Created by Alexander Semenov on 10-Aug-18.
 */

public class MRAIDAdView extends BaseAdView<WebAdContract.WebAdPresenter> implements WebAdContract.WebAdView {


    private WebAdContract.WebAdPresenter presenter;

    public MRAIDAdView(@NonNull Context context,
                       @NonNull FullAdWidget view,
                       @NonNull OrientationDelegate orientationDelegate,
                       @NonNull CloseDelegate closeDelegate) {
        super(context, view, orientationDelegate, closeDelegate);
        attachListeners();
    }

    private OnViewTouchListener onViewTouchListener = new OnViewTouchListener() {
        @Override
        public boolean onTouch(MotionEvent event) {
            if (presenter != null) {
                presenter.onViewTouched(event);
            }

            return false;
        }
    };

    @Override
    public void updateWindow() {
        view.updateWindow();
    }

    @Override
    public void setVisibility(boolean isVisible) {
        //?
        view.setVisibility(isVisible ? View.VISIBLE : View.GONE);
    }

    @Override
    public void setPresenter(@NonNull WebAdContract.WebAdPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void showWebsite(@NonNull String url) {
        view.showWebsite(url);
    }

    private void attachListeners() {
        view.setOnViewTouchListener(onViewTouchListener);
    }
}
