package com.vungle.warren.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;

/**
 * Display native ad media content.
 */
public class MediaView extends RelativeLayout {

    private ImageView imageView;

    public MediaView(Context context) {
        super(context);
        initView(context);
    }

    public MediaView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView(context);
    }

    public MediaView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView(context);
    }

    private void initView(@NonNull Context context) {
        imageView = new ImageView(context);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT,
                RelativeLayout.LayoutParams.MATCH_PARENT);
        params.addRule(RelativeLayout.CENTER_IN_PARENT);
        imageView.setLayoutParams(params);
        imageView.setAdjustViewBounds(true);
        addView(imageView);
        requestLayout();
    }

    public ImageView getMainImage() {
        if (imageView == null) {
            initView(getContext());
        }

        return imageView;
    }

    public void destroy() {
        if (imageView != null) {
            imageView.setImageDrawable(null);
            if (imageView.getParent() != null) {
                ((ViewGroup) imageView.getParent()).removeView(imageView);
            }
            imageView = null;
        }
    }
}
