package com.vungle.warren.utility;

import com.vungle.warren.BuildConfig;

import java.util.concurrent.TimeUnit;

/**
 * Utility class to provide timeout in multithreading environment
 */
public class ConcurrencyTimeoutProvider implements TimeoutProvider {

    //Use Long.MAX_VALUE if in DEBUG mode
    private static final long OPERATION_TIMEOUT = BuildConfig.DEBUG ? Long.MAX_VALUE :
            TimeUnit.SECONDS.toMillis(4);

    /**
     * Method to provide timeout in multithreading environment
     * based on current thread and DEBUG mode.
     * If in DEBUG or current thread is not main then Long.MAX_VALUE
     * will be used.
     *
     * @return timeout in millis
     */
    @Override
    public long getTimeout() {
        return ThreadUtil.isMainThread() ? OPERATION_TIMEOUT : Long.MAX_VALUE;
    }

}
