package com.vungle.warren.utility;

import android.util.Log;

import androidx.annotation.NonNull;

import com.vungle.warren.model.Cookie;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;

public class CookieUtil {

    private static final String TAG = CookieUtil.class.getSimpleName();

    /**
     * Be Mindful of which thread this is invoked, not called on same thread
     * @param repository
     * @param cookieName
     * @param value
     */
    public static void update(@NonNull Repository repository, String cookieName, String key, Object value) {
        Cookie cookie = repository.load(cookieName, Cookie.class).get();
        if (cookie == null) {
            cookie = new Cookie(cookieName);
        }
        cookie.putValue(key, value);
        try {
            repository.save(cookie);
        } catch (DatabaseHelper.DBException e) {
            Log.e(TAG, "DB Exception saving cookie", e);
        }
    }

    public static Boolean getBoolean(@NonNull Repository repository, String cookieName, String key) {
        Cookie cookie = repository.load(cookieName, Cookie.class).get();
        if (cookie != null) {
            return cookie.getBooleanOrNull(key);
        }
        return null;
    }
}
