package com.vungle.warren.utility;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.vungle.warren.ui.PresenterAdOpenCallback;

import java.net.URISyntaxException;

public class ExternalRouter {

    public static final String TAG = ExternalRouter.class.getSimpleName();

    public static boolean launch(@Nullable String deeplinkUrl, @Nullable String url, @NonNull Context context,
                                 @Nullable ActivityManager.LeftApplicationCallback leftApplicationCallback, boolean contextIsNotActivity, PresenterAdOpenCallback adOpenCallback) {
        if ((TextUtils.isEmpty(deeplinkUrl) && TextUtils.isEmpty(url)) || context == null) {
            return false;
        }
        try {
            Intent deeplinkIntent = getIntentFromUrl(deeplinkUrl, contextIsNotActivity);
            Intent fallbackIntent = getIntentFromUrl(url, contextIsNotActivity);
            ActivityManager.startWhenForeground(context, deeplinkIntent, fallbackIntent, leftApplicationCallback, adOpenCallback);
            return true;
        } catch (Exception e) {
            Log.e(TAG, "Error while opening url" + e.getLocalizedMessage());
        }

        Log.d(TAG, "Cannot open url " + url);
        return false;
    }

    private static Intent getIntentFromUrl(String url, boolean contextIsNotActivity) {
        Intent intent = null;
        try {
            intent = TextUtils.isEmpty(url) ? null : Intent.parseUri(url, 0);
            if (intent != null && contextIsNotActivity) {  /* case for NativeAds API which can only use ApplicationContext */
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            }
        } catch (URISyntaxException e) {
            Log.e(TAG, "url format is not correct " + e.getLocalizedMessage());
        }
        return intent;

    }
}
