package com.vungle.warren.utility;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

import androidx.annotation.NonNull;

public class NamedThreadFactory implements ThreadFactory {
    private final String name;
    private ThreadFactory threadFactory = java.util.concurrent.Executors.defaultThreadFactory();
    private AtomicInteger atomicInteger = new AtomicInteger(0);

    public NamedThreadFactory(String name) {
        this.name = name;
    }

    public Thread newThread(@NonNull Runnable r) {
        Thread t = threadFactory.newThread(r);
        t.setName(name + "-th-" + atomicInteger.incrementAndGet());
        return t;
    }
}