package com.vungle.warren.utility;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;

import androidx.annotation.NonNull;

/**
 * Utility class for threading env
 */
public class ThreadUtil {

    private static final Handler UI_HANDLER = new Handler(Looper.getMainLooper());

    /**
     * Checks if thread where this method is called is main.
     *
     * @return {@code true} if current thread is main {@code false} otherwise
     */
    public static boolean isMainThread() {
        Looper mainLooper = Looper.getMainLooper();

        if (mainLooper == null)
            return false;

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M)
            return mainLooper.isCurrentThread();

        Looper myLooper = Looper.myLooper();

        return myLooper != null && mainLooper.getThread().equals(myLooper.getThread());
    }

    /**
     * Performs the given runnable on the main thread.
     */
    public static void runOnUiThread(final @NonNull Runnable runnable) {
        if (isMainThread()) {
            runnable.run();
        } else {
            UI_HANDLER.post(runnable);
        }
    }
}
