package com.vungle.warren.utility;

import com.vungle.warren.persistence.FutureResult;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class VungleThreadPoolExecutor extends ThreadPoolExecutor {

    public VungleThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        allowCoreThreadTimeOut(true);
    }

    @Override
    public void execute(Runnable command) {
        try {
            super.execute(command);
        } catch (OutOfMemoryError ignored) {
        }
    }

    public void execute(Runnable command, Runnable fail) {
        try {
            super.execute(command);
        } catch (OutOfMemoryError ignored) {
            fail.run();
        }
    }

    @Override
    public Future<?> submit(Runnable task) {
        try {
            return super.submit(task);
        } catch (OutOfMemoryError ignored) {
            return new FutureResult<>(null);
        }
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        try {
            return super.submit(task, result);
        } catch (OutOfMemoryError ignored) {
            return new FutureResult<>(null);
        }
    }

    public Future<?> submit(Runnable task, Runnable fail) {
        try {
            return super.submit(task);
        } catch (OutOfMemoryError ignored) {
            fail.run();
            return new FutureResult<>(null);
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        try {
            return super.submit(task);
        } catch (OutOfMemoryError ignored) {
            return new FutureResult<>(null);
        }
    }
}
