package com.vungle.warren.utility;

import android.util.Log;

import java.net.MalformedURLException;
import java.net.URL;

public class VungleUrlUtility {

    private final static String TAG = VungleUrlUtility.class.getSimpleName();

    /**
     *
     * @param url
     * @return true/false if we should attempt to persist this failed tpat
     */
    public static boolean isVungleUrl(String url) {
        //tpats:
        //https://ingest.vungle.com/tpat?event_id=...
        //https://events.api.vungle.com/api/v5/tpat?adv=...
        try {
            URL uri = new URL(url);
            return uri.getHost().toLowerCase().contains(".vungle.com");
        } catch (MalformedURLException e) {
            Log.e(TAG, e.getMessage());
            return false;
        }
    }
}
