package com.vungle.warren.utility;

import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.error.VungleException;

import java.lang.ref.WeakReference;

public class WeakLoadAdCallback implements LoadAdCallback {
    private WeakReference<LoadAdCallback> weak;

    public WeakLoadAdCallback(LoadAdCallback callback) {
        this.weak = new WeakReference<>(callback);
    }

    @Override
    public void onAdLoad(String placementId) {
        LoadAdCallback callback = weak.get();
        if (callback != null) {
            callback.onAdLoad(placementId);
        }
    }

    @Override
    public void onError(String placementId, VungleException exception) {
        LoadAdCallback callback = weak.get();
        if (callback != null) {
            callback.onError(placementId, exception);
        }
    }
}
