package com.vungle.warren.utility.platform;

import androidx.annotation.Nullable;
import androidx.core.util.Consumer;

import com.vungle.warren.model.AdvertisingInfo;

public interface Platform {

    String MANUFACTURER_AMAZON = "Amazon";

    boolean isAtLeastMinimumSDK();

    boolean getIsBatterySaverEnabled();

    boolean getIsSideloaded();

    double getVolumeLevel();

    boolean getIsSoundEnabled();

    boolean getIsSDCardPresent();

    @Nullable
    String getUserAgent();

    void getUserAgentLazy(Consumer<String> consumer);

    AdvertisingInfo getAdvertisingInfo();

    String getAppSetId();

    String getAndroidId();

    /**
     * Method to disable automatic fallback collection of Android ID in case ifa is not available.
     */
    void setAndroidIdFallbackDisabled(boolean disabled);
}

