package com.vungle.warren.utility.platform;

import static com.vungle.warren.model.Cookie.USER_AGENT_ID_COOKIE;

import android.content.Context;
import android.os.Build;
import android.util.AndroidRuntimeException;
import android.webkit.WebSettings;

import androidx.core.util.Consumer;

import com.vungle.warren.VungleLogger;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;

public class WebViewUtil {

    private final Context context;

    private final String TAG = WebViewUtil.class.getSimpleName();
    private final Repository repository;

    public WebViewUtil(Context context, Repository repository) {
        this.context = context;
        this.repository = repository;
    }

    public void getUserAgent(Consumer<String> consumer) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            try {
                String userAgent = WebSettings.getDefaultUserAgent(context);
                consumer.accept(userAgent);
                addUserAgentInCookie(userAgent);
            } catch (Exception e) {
                if (e instanceof DatabaseHelper.DBException) {
                    VungleLogger.error(TAG, "Ran into database issue");
                }
                if (e instanceof AndroidRuntimeException) {
                    VungleLogger.error(TAG, "WebView could be missing here");
                }
                consumer.accept(null);
            }
            return;
        }
        consumer.accept(null);
    }

    private void addUserAgentInCookie(String userAgent) throws DatabaseHelper.DBException {
        Cookie cookie = new Cookie(USER_AGENT_ID_COOKIE);
        cookie.putValue("userAgent", userAgent);
        repository.save(cookie);
    }
}
