/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.AdLoader;
import com.vungle.warren.AdRequest;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.SessionTracker;
import com.vungle.warren.VisionController;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Placement;
import com.vungle.warren.model.SessionData;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.session.SessionAttribute;
import com.vungle.warren.session.SessionEvent;
import com.vungle.warren.tasks.JobRunner;
import com.vungle.warren.tasks.SendReportsJob;
import com.vungle.warren.ui.contract.AdContract;
import java.util.Map;

public class AdEventListener
implements AdContract.AdvertisementPresenter.EventListener {
    private static final String TAG = AdEventListener.class.getCanonicalName();
    private final Repository repository;
    private final AdLoader adLoader;
    private final JobRunner jobRunner;
    private final VisionController visionController;
    private final Map<String, Boolean> playOperations;
    private final PlayAdCallback playAdCallback;
    private final AdRequest request;
    private boolean successfulView;
    private int percentViewed = -1;
    private boolean adRewarded;
    private Placement placement;
    private Advertisement advertisement;

    AdEventListener(@NonNull AdRequest request, @NonNull Map<String, Boolean> playOperations, @Nullable PlayAdCallback playAdCallback, @NonNull Repository repository, @NonNull AdLoader adLoader, @NonNull JobRunner jobRunner, @NonNull VisionController visionController, @Nullable Placement placement, @Nullable Advertisement advertisement) {
        this.request = request;
        this.playOperations = playOperations;
        this.playAdCallback = playAdCallback;
        this.repository = repository;
        this.adLoader = adLoader;
        this.jobRunner = jobRunner;
        this.visionController = visionController;
        this.placement = placement;
        this.advertisement = advertisement;
        playOperations.put(request.getPlacementId(), true);
    }

    @Override
    public void onNext(@NonNull String s, String value, String id2) {
        this.loadAdvertisement();
        if (this.advertisement == null) {
            Log.e((String)TAG, (String)"No Advertisement for ID");
            this.onFinished();
            if (this.playAdCallback != null) {
                this.playAdCallback.onError(this.request.getPlacementId(), new VungleException(10));
                VungleLogger.error("AdEventListener#PlayAdCallback", id2 + ": AD_UNABLE_TO_PLAY");
            }
            return;
        }
        this.loadPlacement();
        if (this.placement == null) {
            Log.e((String)TAG, (String)"No Placement for ID");
            this.onFinished();
            if (this.playAdCallback != null) {
                this.playAdCallback.onError(this.request.getPlacementId(), new VungleException(13));
                VungleLogger.error("AdEventListener#PlayAdCallback", "PLACEMENT_NOT_FOUND: " + id2);
            }
            return;
        }
        try {
            if (s.equals("start")) {
                this.repository.saveAndApplyState(this.advertisement, id2, 2);
                if (this.playAdCallback != null) {
                    this.playAdCallback.onAdStart(id2);
                    VungleLogger.debug("AdEventListener#PlayAdCallback", "onAdStart: " + id2);
                }
                this.percentViewed = 0;
                this.placement = this.repository.load(this.request.getPlacementId(), Placement.class).get();
                if (this.placement != null) {
                    this.adLoader.loadEndlessIfNeeded(this.placement, this.placement.getAdSize(), 0L, this.request.getIsExplicit());
                }
                if (this.visionController.isEnabled()) {
                    this.visionController.reportData(this.advertisement.getCreativeId(), this.advertisement.getCampaignId(), this.advertisement.getAdvertiserAppId());
                }
            } else if (s.equals("end")) {
                Log.d((String)"Vungle", (String)("Cleaning up metadata and assets for placement " + id2 + " and advertisement " + this.advertisement.getId()));
                this.repository.saveAndApplyState(this.advertisement, id2, 3);
                this.repository.updateAndSaveReportState(id2, this.advertisement.getAppID(), 0, 1);
                this.jobRunner.execute(SendReportsJob.makeJobInfo(false));
                this.onFinished();
                if (this.playAdCallback != null) {
                    this.playAdCallback.onAdEnd(id2, this.successfulView || this.percentViewed >= 80, value != null && value.equals("isCTAClicked"));
                    this.playAdCallback.onAdEnd(id2);
                    SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.DID_CLOSE).addData(SessionAttribute.EVENT_ID, this.advertisement.getId()).build());
                    VungleLogger.debug("AdEventListener#PlayAdCallback", "onAdEnd: " + id2);
                }
            } else if (s.equals("successfulView") && this.placement.isIncentivized()) {
                this.successfulView = true;
                if (!this.adRewarded) {
                    this.adRewarded = true;
                    if (this.playAdCallback != null) {
                        this.playAdCallback.onAdRewarded(id2);
                        SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.REWARDED).addData(SessionAttribute.EVENT_ID, this.advertisement.getId()).build());
                        VungleLogger.debug("AdEventListener#PlayAdCallback", "onAdRewarded: " + id2);
                    }
                }
            } else if ("open".equals(s) && this.playAdCallback != null) {
                if ("adClick".equals(value)) {
                    this.playAdCallback.onAdClick(id2);
                    VungleLogger.debug("AdEventListener#PlayAdCallback", "onAdClick: " + id2);
                } else if ("adLeftApplication".equals(value)) {
                    this.playAdCallback.onAdLeftApplication(id2);
                    VungleLogger.debug("AdEventListener#PlayAdCallback", "onAdLeftApplication: " + id2);
                }
            } else if ("adViewed".equals(s) && this.playAdCallback != null) {
                this.playAdCallback.onAdViewed(id2);
            } else if ("attach".equals(s) && this.playAdCallback != null) {
                this.playAdCallback.creativeId(value);
            }
        }
        catch (DatabaseHelper.DBException ignored) {
            this.onError(new VungleException(26), id2);
        }
    }

    @Override
    public void onError(VungleException exception, String placementId) {
        this.loadAdvertisement();
        if (this.advertisement != null && exception.getExceptionCode() == 27) {
            this.adLoader.dropCache(this.advertisement.getId());
            return;
        }
        if (this.advertisement != null && exception.getExceptionCode() != 15 && exception.getExceptionCode() != 25 && exception.getExceptionCode() != 36) {
            try {
                this.repository.saveAndApplyState(this.advertisement, placementId, 4);
                this.loadPlacement();
                if (this.placement != null) {
                    this.adLoader.loadEndlessIfNeeded(this.placement, this.placement.getAdSize(), 0L, false);
                }
            }
            catch (DatabaseHelper.DBException e2) {
                exception = new VungleException(26);
            }
        }
        this.onFinished();
        if (this.playAdCallback != null) {
            this.playAdCallback.onError(placementId, exception);
            VungleLogger.error("AdEventListener#PlayAdCallback", exception.getLocalizedMessage() + " :" + placementId);
        }
    }

    protected void onFinished() {
        this.playOperations.remove(this.request.getPlacementId());
    }

    private void loadAdvertisement() {
        if (this.advertisement == null) {
            this.advertisement = this.repository.findValidAdvertisementForPlacement(this.request.getPlacementId(), this.request.getEventId()).get();
        }
    }

    private void loadPlacement() {
        if (this.placement == null) {
            this.placement = this.repository.load(this.request.getPlacementId(), Placement.class).get();
        }
    }
}

