/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.text.TextUtils;
import android.util.Log;
import android.webkit.URLUtil;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vungle.warren.AdConfig;
import com.vungle.warren.AdRequest;
import com.vungle.warren.HeaderBiddingCallback;
import com.vungle.warren.InitCallback;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.LoadNativeAdCallbackWrapper;
import com.vungle.warren.OperationSequence;
import com.vungle.warren.RuntimeValues;
import com.vungle.warren.SessionTracker;
import com.vungle.warren.VisionController;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.VungleSettings;
import com.vungle.warren.VungleStaticApi;
import com.vungle.warren.analytics.JobDelegateAnalytics;
import com.vungle.warren.downloader.AssetDownloadListener;
import com.vungle.warren.downloader.AssetPriority;
import com.vungle.warren.downloader.DownloadRequest;
import com.vungle.warren.downloader.Downloader;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.AdAsset;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.JsonUtil;
import com.vungle.warren.model.Placement;
import com.vungle.warren.model.SessionData;
import com.vungle.warren.model.admarkup.AdMarkupV2;
import com.vungle.warren.network.Call;
import com.vungle.warren.network.Callback;
import com.vungle.warren.network.Response;
import com.vungle.warren.omsdk.OMInjector;
import com.vungle.warren.persistence.CacheManager;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.session.SessionAttribute;
import com.vungle.warren.session.SessionConstants;
import com.vungle.warren.session.SessionEvent;
import com.vungle.warren.tasks.DownloadJob;
import com.vungle.warren.tasks.JobRunner;
import com.vungle.warren.ui.HackMraid;
import com.vungle.warren.utility.Executors;
import com.vungle.warren.utility.FileUtility;
import com.vungle.warren.utility.UnzipUtility;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class AdLoader {
    private static final String TAG = AdLoader.class.getCanonicalName();
    public static final long EXPONENTIAL_RATE = 2L;
    public static final long RETRY_DELAY = 2000L;
    public static final int RETRY_COUNT = 5;
    public static final boolean DEFAULT_LOAD_OPTIMIZATION_ENABLED = false;
    public static final String TT_DOWNLOAD_CONTEXT = "ttDownloadContext";
    private static final String LOAD_AD_EXECUTE_CONTEXT = "AdLoader#loadAd#execute; loadAd sequence";
    private static final String FETCH_AD_METADATA_CONTEXT = "AdLoader#fetchAdMetadata; loadAd sequence";
    private static final String DOWNLOAD_AD_ASSETS_CONTEXT = "AdLoader#downloadAdAssets; loadAd sequence";
    private static final String GET_ASSET_DOWNLOAD_LISTENER_CONTEXT = "AdLoader#getAssetDownloadListener; loadAd sequence";
    private static final String ON_ASSET_DOWNLOAD_FINISHED_CONTEXT = "AdLoader#onAssetDownloadFinished; loadAd sequence";
    private static final String DOWNLOAD_AD_CALLBACK_ON_DOWNLOAD_COMPLETED_CONTEXT = "AdLoader#DownloadAdCallback#onDownloadCompleted; loadAd sequence";
    private static final String NOT_A_DIR = "not a dir";
    private static final String STRING_AND_OP_ID_FORMAT = "%1$s; request = %2$s";
    private static final String OP_ID_AND_ADVERTISEMENT_FORMAT = "request = %1$s; advertisement = %2$s";
    private static final String PLACEMENT_ID_AND_ADVERTISEMENT_FORMAT_3_4 = "request = %3$s; advertisement = %4$s";
    private static final String PLACEMENT_ID_AND_ADVERTISEMENT_FORMAT_2_3 = "request = %2$s; advertisement = %3$s";
    private final Map<AdRequest, Operation> loadOperations = new ConcurrentHashMap<AdRequest, Operation>();
    private final Map<AdRequest, Operation> pendingOperations = new ConcurrentHashMap<AdRequest, Operation>();
    private final List<Operation> startingOperations = new CopyOnWriteArrayList<Operation>();
    private final OperationSequence sequence;
    @Nullable
    private AdRequest sequenceLoadingRequest = null;
    @NonNull
    private final Repository repository;
    @NonNull
    private final Executors sdkExecutors;
    @NonNull
    private final VungleApiClient vungleApiClient;
    @NonNull
    private final CacheManager cacheManager;
    @NonNull
    private final Downloader downloader;
    @NonNull
    private final RuntimeValues runtimeValues;
    @NonNull
    private final AtomicReference<JobRunner> jobRunnerRef = new AtomicReference();
    @NonNull
    private final VungleStaticApi vungleApi;
    @NonNull
    private final VisionController visionController;
    @NonNull
    private final OMInjector omInjector;
    private boolean adLoadOptimizationEnabled = false;

    public AdLoader(@NonNull Executors sdkExecutors, @NonNull Repository repository, @NonNull VungleApiClient vungleApiClient, @NonNull CacheManager cacheManager, @NonNull Downloader downloader, @NonNull RuntimeValues runtimeValues, @NonNull VungleStaticApi vungleApi, @NonNull VisionController visionController, @NonNull OperationSequence sequence, @NonNull OMInjector omInjector) {
        this.sdkExecutors = sdkExecutors;
        this.repository = repository;
        this.vungleApiClient = vungleApiClient;
        this.cacheManager = cacheManager;
        this.downloader = downloader;
        this.runtimeValues = runtimeValues;
        this.vungleApi = vungleApi;
        this.visionController = visionController;
        this.sequence = sequence;
        this.omInjector = omInjector;
    }

    public void init(@NonNull JobRunner jobRunner) {
        this.jobRunnerRef.set(jobRunner);
        this.downloader.init();
    }

    private boolean canReDownload(Advertisement advertisement) {
        if (advertisement == null || advertisement.getState() != 0 && advertisement.getState() != 1) {
            return false;
        }
        List<AdAsset> adAssets = this.repository.loadAllAdAssets(advertisement.getId()).get();
        if (adAssets == null || adAssets.size() == 0) {
            return false;
        }
        for (AdAsset asset : adAssets) {
            File file;
            if (!(asset.fileType == 1 ? !this.fileIsValid(file = new File(asset.localPath), asset) : TextUtils.isEmpty((CharSequence)asset.serverPath))) continue;
            return false;
        }
        return true;
    }

    @WorkerThread
    public boolean canPlayAd(Advertisement advertisement) {
        if (advertisement == null || advertisement.getState() != 1) {
            return false;
        }
        return this.hasAssetsFor(advertisement);
    }

    @WorkerThread
    public boolean canRenderAd(Advertisement advertisement) {
        if (advertisement == null) {
            return false;
        }
        if (advertisement.getState() != 1 && advertisement.getState() != 2) {
            return false;
        }
        return this.hasAssetsFor(advertisement);
    }

    public void clear() {
        HashSet<AdRequest> requests = new HashSet<AdRequest>();
        requests.addAll(this.loadOperations.keySet());
        requests.addAll(this.pendingOperations.keySet());
        for (AdRequest request : requests) {
            Operation loading = this.loadOperations.remove(request);
            this.startingOperations.remove(loading);
            this.onError(loading, 25);
            this.onError(this.pendingOperations.remove(request), 25);
        }
        for (Operation op : this.startingOperations) {
            this.startingOperations.remove(op);
            this.onError(op, 25);
        }
        this.sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AdLoader.this.sequenceLoadingRequest = null;
                for (OperationSequence.Entry op : AdLoader.this.sequence.removeAll()) {
                    AdLoader.this.onError(op.operation, 25);
                }
            }
        });
    }

    public boolean isLoading(AdRequest request) {
        Operation op = this.loadOperations.get(request);
        return op != null && op.loading.get();
    }

    private void setLoading(AdRequest request, boolean loading) {
        Operation op = this.loadOperations.get(request);
        if (op != null) {
            op.loading.set(loading);
        }
    }

    public void loadPendingInternal(AdRequest request) {
        Operation op = this.pendingOperations.remove(request);
        if (op == null) {
            return;
        }
        this.load(op.delay(0L));
    }

    public void load(final @NonNull Operation op) {
        JobRunner jobRunner = this.jobRunnerRef.get();
        if (jobRunner == null) {
            VungleLogger.error("AdLoader#load; loadAd sequence", String.format("Cannot load operation %s; job runner is null", op));
            this.onError(op, 9);
            return;
        }
        if (op.request.getIsExplicit()) {
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.LOAD_AD).addData(SessionAttribute.PLACEMENT_ID, op.request.getPlacementId()).build());
        }
        this.checkAndUpdateHBPPlacementBannerSize(op.request.getPlacementId(), op.size);
        Operation pending = this.pendingOperations.remove(op.request);
        if (pending != null) {
            op.merge(pending);
        }
        if (op.delay <= 0L) {
            op.request.timeStamp.set(System.currentTimeMillis());
            this.startingOperations.add(op);
            this.sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    if (!AdLoader.this.startingOperations.contains(op)) {
                        return;
                    }
                    Operation starting = op;
                    Operation current = (Operation)AdLoader.this.loadOperations.get(starting.request);
                    if (current != null) {
                        int oldPriority = current.priority;
                        current.merge(starting);
                        if (current.priority < oldPriority) {
                            AdLoader.this.onChangePriority(current);
                        }
                    } else {
                        OperationSequence.Entry next = AdLoader.this.sequence.remove(starting.request);
                        if (next != null) {
                            next.operation.merge(starting);
                            starting = next.operation;
                        }
                        if (starting.priority <= 0) {
                            AdLoader.this.startLoading(starting);
                        } else {
                            AdLoader.this.sequence.offer(next == null ? new OperationSequence.Entry(starting) : next);
                            AdLoader.this.tryLoadNextInQueue(null);
                        }
                    }
                    AdLoader.this.startingOperations.remove(starting);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    AdLoader.this.onError(op, 39);
                }
            });
        } else {
            this.pendingOperations.put(op.request, op);
            jobRunner.execute(DownloadJob.makeJobInfo(op.request).setDelay(op.delay).setUpdateCurrent(true));
        }
    }

    private void checkAndUpdateHBPPlacementBannerSize(String placementId, final AdConfig.AdSize newAdSize) {
        this.repository.load(placementId, Placement.class, new Repository.LoadCallback<Placement>(){

            @Override
            public void onLoaded(Placement placement) {
                if (placement != null && placement.isMultipleHBPEnabled() && placement.getPlacementAdType() == 1 && placement.getAdSize() != newAdSize) {
                    placement.setAdSize(newAdSize);
                    AdLoader.this.repository.save(placement, null, false);
                }
            }
        });
    }

    @WorkerThread
    private void startLoading(Operation op) {
        this.loadOperations.put(op.request, op);
        this.loadAd(op);
    }

    @WorkerThread
    private void tryLoadNextInQueue(@Nullable AdRequest finished) {
        if (this.sequenceLoadingRequest == null || this.sequenceLoadingRequest.equals(finished)) {
            this.sequenceLoadingRequest = null;
            OperationSequence.Entry next = this.sequence.poll();
            if (next != null) {
                this.sequenceLoadingRequest = next.operation.request;
                this.startLoading(next.operation);
            }
        }
    }

    private void onChangePriority(Operation op) {
        for (DownloadRequest request : op.requests) {
            AssetPriority priority = this.getAssetPriority(op.priority, request.path);
            request.setPriority(priority);
            this.downloader.updatePriority(request);
        }
    }

    private void onError(@Nullable Operation op, @VungleException.ExceptionCode int code) {
        VungleLogger.error("AdLoader#onError; loadAd sequence", String.format("Error %1$s occured; operation is %2$s", new VungleException(code), op != null ? op : "null"));
        if (op != null) {
            for (LoadAdCallback loadAdCallback : op.loadAdCallbacks) {
                loadAdCallback.onError(op.request.getPlacementId(), new VungleException(code));
            }
        }
    }

    private VungleException reposeCodeToVungleException(int code) {
        if (this.recoverableServerCode(code)) {
            return new VungleException(22);
        }
        return new VungleException(21);
    }

    private boolean recoverableServerCode(int code) {
        return code == 408 || 500 <= code && code < 600;
    }

    private VungleException retrofitToVungleException(Throwable throwable) {
        if (throwable instanceof UnknownHostException) {
            return new VungleException(11);
        }
        if (throwable instanceof IOException) {
            return new VungleException(20);
        }
        return new VungleException(11);
    }

    @WorkerThread
    private void loadAd(@NonNull Operation op) {
        List<Advertisement> advs;
        long adRequestStartTimeStamp = System.currentTimeMillis();
        if (!this.vungleApi.isInitialized()) {
            VungleLogger.error(LOAD_AD_EXECUTE_CONTEXT, "Vungle is not initialized");
            this.onDownloadFailed(new VungleException(9), op.request, null);
            return;
        }
        Placement placement = this.repository.load(op.request.getPlacementId(), Placement.class).get();
        if (placement == null) {
            VungleLogger.error(LOAD_AD_EXECUTE_CONTEXT, "placement not found for " + op.request);
            this.onDownloadFailed(new VungleException(13), op.request, null);
            return;
        }
        if (!placement.isValid()) {
            this.onDownloadFailed(new VungleException(5), op.request, null);
            return;
        }
        if (this.isSizeInvalid(placement, op.size)) {
            VungleLogger.error(LOAD_AD_EXECUTE_CONTEXT, "size is invalid, size = " + (Object)((Object)op.size));
            this.onDownloadFailed(new VungleException(28), op.request, null);
            return;
        }
        if (placement.getPlacementAdType() == 1 && !placement.isMultipleHBPEnabled() && (advs = this.repository.findValidAdvertisementsForPlacement(placement.getId(), op.request.getEventId()).get()) != null) {
            boolean deleted = false;
            for (Advertisement adv : advs) {
                if (adv.getAdConfig().getAdSize() == op.size) continue;
                try {
                    this.repository.deleteAdvertisement(adv.getId());
                }
                catch (DatabaseHelper.DBException e2) {
                    VungleLogger.error(LOAD_AD_EXECUTE_CONTEXT, "cannot delete advertisement, request = " + op.request);
                    this.onDownloadFailed(new VungleException(26), op.request, null);
                    return;
                }
                deleted = true;
            }
            if (deleted) {
                this.loadEndlessIfNeeded(placement, op.size, 0L, op.request.getIsExplicit());
            }
        }
        Advertisement advertisement = null;
        int type = op.request.getType();
        if (type == 0 || type == 2) {
            advertisement = this.repository.findValidAdvertisementForPlacement(placement.getId(), op.request.getEventId()).get();
            if (op.request.getAdMarkup() != null && advertisement == null && op.request.getAdMarkup().getVersion() == 2) {
                AdMarkupV2 adMarkupV2 = (AdMarkupV2)op.request.getAdMarkup();
                advertisement = adMarkupV2.getAdvertisement();
                try {
                    this.repository.save(advertisement);
                }
                catch (DatabaseHelper.DBException e3) {
                    Log.e((String)TAG, (String)"Failed to persist ad from Real Time Ad");
                }
            }
            if (placement.isMultipleHBPEnabled() && op.request.getType() == 0) {
                String eventId = op.request.getEventId();
                if (eventId == null) {
                    this.onDownloadFailed(new VungleException(36), op.request, null);
                    return;
                }
                if (advertisement == null) {
                    this.onDownloadFailed(new VungleException(10), op.request, null);
                    return;
                }
            }
            if (advertisement != null && this.canPlayAd(advertisement)) {
                this.tryLoadNextInQueue(op.request);
                this.onReady(op.request, placement, advertisement);
                return;
            }
            if (this.canReDownload(advertisement)) {
                Log.d((String)TAG, (String)"Found valid adv but not ready - downloading content");
                VungleSettings settings = this.runtimeValues.settings.get();
                if (settings == null || this.cacheManager.getBytesAvailable() < settings.getMinimumSpaceForAd()) {
                    if (advertisement.getState() != 4) {
                        try {
                            this.repository.saveAndApplyState(advertisement, op.request.getPlacementId(), 4);
                        }
                        catch (DatabaseHelper.DBException e4) {
                            VungleLogger.error("AdLoader#loadAd#execute; loadAd sequence; canReDownload branch", "cannot save/apply ERROR state, request = " + op.request);
                            this.onDownloadFailed(new VungleException(26), op.request, null);
                            return;
                        }
                    }
                    VungleLogger.error(LOAD_AD_EXECUTE_CONTEXT, "failed to download assets, no space; request = " + op.request);
                    this.onDownloadFailed(new VungleException(19), op.request, null);
                    return;
                }
                this.setLoading(op.request, true);
                if (advertisement.getState() != 0) {
                    try {
                        this.repository.saveAndApplyState(advertisement, op.request.getPlacementId(), 0);
                    }
                    catch (DatabaseHelper.DBException e5) {
                        VungleLogger.error("AdLoader#loadAd#execute; loadAd sequence; canReDownload branch", "cannot save/apply NEW state, request = " + op.request);
                        this.onDownloadFailed(new VungleException(26), op.request, null);
                        return;
                    }
                }
                advertisement.setAdRequestStartTime(adRequestStartTimeStamp);
                advertisement.setAssetDownloadStartTime(System.currentTimeMillis());
                this.tryLoadNextInQueue(op.request);
                this.downloadAdAssets(op, advertisement);
                return;
            }
        } else if (op.request.getType() == 1 && this.isReadyForHBP(op, this.repository)) {
            this.tryLoadNextInQueue(op.request);
            this.onReady(op.request, placement, null);
            return;
        }
        if (placement.getWakeupTime() > System.currentTimeMillis()) {
            this.onDownloadFailed(new VungleException(1), op.request, null);
            VungleLogger.warn("AdLoader#loadAd#execute; loadAd sequence; snoozed branch", String.format("Placement with id %s is snoozed ", placement.getId()));
            Log.w((String)TAG, (String)("Placement " + placement.getId() + " is  snoozed"));
            Log.d((String)TAG, (String)("Placement " + placement.getId() + " is sleeping rescheduling it "));
            this.loadEndlessIfNeeded(placement, op.size, placement.getWakeupTime() - System.currentTimeMillis(), false);
        } else {
            VungleSettings settings;
            String advMsg = op.request.getType() == 1 ? "advs" : "adv";
            Log.i((String)TAG, (String)("didn't find cached " + advMsg + " for " + op.request + " downloading"));
            if (advertisement != null) {
                try {
                    this.repository.saveAndApplyState(advertisement, op.request.getPlacementId(), 4);
                }
                catch (DatabaseHelper.DBException e6) {
                    VungleLogger.error("AdLoader#loadAd#execute; loadAd sequence; last else branch", "cannot save/apply ERROR state, request = " + op.request);
                    this.onDownloadFailed(new VungleException(26), op.request, null);
                    return;
                }
            }
            if ((settings = this.runtimeValues.settings.get()) != null && this.cacheManager.getBytesAvailable() < settings.getMinimumSpaceForAd()) {
                VungleLogger.error("AdLoader#loadAd#execute; loadAd sequence; last else branch", String.format("no space to load, isAutoCached = %1$s, request = %2$s", placement.isAutoCached(), op.request));
                this.onDownloadFailed(new VungleException(placement.isAutoCached() ? 18 : 17), op.request, null);
                return;
            }
            Log.d((String)TAG, (String)("No " + advMsg + " for placement " + placement.getId() + " getting new data "));
            this.setLoading(op.request, true);
            this.fetchAdMetadata(op, placement);
        }
    }

    private boolean isReadyForHBP(@NonNull Operation op, @NonNull Repository repository) {
        List<Advertisement> advs = repository.findValidAdvertisementsForPlacement(op.request.getPlacementId(), null).get();
        return advs != null && (long)advs.size() >= op.request.getAdCount();
    }

    private boolean isSizeInvalid(Placement placement, AdConfig.AdSize size) {
        return placement.getPlacementAdType() == 1 && !AdConfig.AdSize.isNonMrecBannerAdSize(size) || placement.getPlacementAdType() == 0 && !AdConfig.AdSize.isDefaultAdSize(size);
    }

    private void fetchAdMetadata(final @NonNull Operation op, @NonNull Placement placement) {
        final long requestStartTime = System.currentTimeMillis();
        if (op.request.getAdMarkup() instanceof AdMarkupV2) {
            AdMarkupV2 adMarkupV2 = (AdMarkupV2)op.request.getAdMarkup();
            this.handleAdMetaData(op, requestStartTime, adMarkupV2.getAdvertisement(), placement, new JsonObject());
            return;
        }
        VungleLogger.verbose(true, TAG, TT_DOWNLOAD_CONTEXT, String.format("Start to request ad, request = %1$s, at: %2$d", op.request, requestStartTime));
        this.vungleApiClient.requestAd(op.request.getPlacementId(), AdConfig.AdSize.isNonMrecBannerAdSize(op.size) ? op.size.getName() : "", placement.isHeaderBidding(), this.visionController.isEnabled() ? this.visionController.getPayload() : null).enqueue(new Callback<JsonObject>(){

            @Override
            public void onFailure(Call<JsonObject> call, final Throwable e2) {
                VungleLogger.verbose(true, TAG, AdLoader.TT_DOWNLOAD_CONTEXT, String.format("Request ad failed, request = %1$s, elapsed time = %2$dms", op.request, System.currentTimeMillis() - requestStartTime));
                VungleLogger.error(AdLoader.FETCH_AD_METADATA_CONTEXT, String.format("failed to request ad, request = %1$s, throwable = %2$s", op.request, e2));
                AdLoader.this.sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        AdLoader.this.onDownloadFailed(AdLoader.this.retrofitToVungleException(e2), op.request, null);
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        AdLoader.this.onCriticalFail(39, op.request);
                    }
                });
            }

            @Override
            public void onResponse(Call<JsonObject> call, final Response<JsonObject> response) {
                VungleLogger.verbose(true, TAG, AdLoader.TT_DOWNLOAD_CONTEXT, String.format("Request ad got response, request = %1$s, elapsed time = %2$dms", op.request, System.currentTimeMillis() - requestStartTime));
                AdLoader.this.sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        Placement placement = AdLoader.this.repository.load(op.request.getPlacementId(), Placement.class).get();
                        if (placement == null) {
                            Log.e((String)TAG, (String)"Placement metadata not found for requested advertisement.");
                            VungleLogger.error(AdLoader.FETCH_AD_METADATA_CONTEXT, "Placement metadata not found for requested advertisement. request = " + op.request);
                            AdLoader.this.onDownloadFailed(new VungleException(2), op.request, null);
                            return;
                        }
                        if (!response.isSuccessful()) {
                            long retryAfterHeaderValue = AdLoader.this.vungleApiClient.getRetryAfterHeaderValue(response);
                            if (retryAfterHeaderValue > 0L && (placement.isAutoCached() || placement.isMultipleHBPEnabled())) {
                                AdLoader.this.loadEndlessIfNeeded(placement, op.size, retryAfterHeaderValue, false);
                                VungleLogger.error(AdLoader.FETCH_AD_METADATA_CONTEXT, "Response was not successful, retrying; request = " + op.request);
                                AdLoader.this.onDownloadFailed(new VungleException(14), op.request, null);
                                return;
                            }
                            Log.e((String)TAG, (String)"Failed to retrieve advertisement information");
                            VungleLogger.error(AdLoader.FETCH_AD_METADATA_CONTEXT, String.format("Response was not successful, not retrying;request = %1$s; responseCode = %2$s", op.request, response.code()));
                            AdLoader.this.onDownloadFailed(AdLoader.this.reposeCodeToVungleException(response.code()), op.request, null);
                            return;
                        }
                        JsonObject jsonObject = (JsonObject)response.body();
                        Log.d((String)TAG, (String)("Ads Response: " + jsonObject));
                        if (jsonObject != null && jsonObject.has("ads") && !jsonObject.get("ads").isJsonNull()) {
                            JsonArray ads = jsonObject.getAsJsonArray("ads");
                            if (ads == null || ads.size() == 0) {
                                VungleLogger.error(AdLoader.FETCH_AD_METADATA_CONTEXT, "Response was successful, but no ads; request = " + op.request);
                                AdLoader.this.onDownloadFailed(new VungleException(1), op.request, null);
                                return;
                            }
                            JsonObject ad = ads.get(0).getAsJsonObject();
                            JsonObject adMarkup = ad.get("ad_markup").getAsJsonObject();
                            AdLoader.this.handleAdMetaData(op, requestStartTime, ad, placement, adMarkup);
                        } else {
                            VungleLogger.error(AdLoader.FETCH_AD_METADATA_CONTEXT, String.format("Response has no ads; placement = %1$s;op.request = %2$s; response = %3$s", placement, op.request, jsonObject));
                            AdLoader.this.onDownloadFailed(new VungleException(1), op.request, null);
                        }
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        AdLoader.this.onCriticalFail(39, op.request);
                    }
                });
            }
        });
    }

    private void handleAdMetaData(Operation op, long requestStartTime, JsonObject advertisement, Placement placement, JsonObject adMarkup) {
        try {
            this.handleAdMetaData(op, requestStartTime, new Advertisement(advertisement), placement, adMarkup);
        }
        catch (IllegalArgumentException badAd) {
            if (adMarkup.has("sleep")) {
                int sleep = adMarkup.get("sleep").getAsInt();
                placement.snooze(sleep);
                try {
                    VungleLogger.warn(FETCH_AD_METADATA_CONTEXT, String.format("badAd - snoozed placement %1$s; request = %2$s", placement, op.request));
                    this.repository.save(placement);
                }
                catch (DatabaseHelper.DBException ignored) {
                    VungleLogger.error(FETCH_AD_METADATA_CONTEXT, String.format("badAd - can't save snoozed placement %1$s; request = %2$s", placement, op.request));
                    this.onDownloadFailed(new VungleException(26), op.request, null);
                    return;
                }
                this.loadEndlessIfNeeded(placement, op.size, (long)sleep * 1000L, false);
            }
            VungleLogger.error(FETCH_AD_METADATA_CONTEXT, String.format("badAd; can't proceed %1$s; request = %2$s", placement, op.request));
            this.onDownloadFailed(new VungleException(1), op.request, null);
        }
    }

    private void handleAdMetaData(Operation op, long requestStartTime, Advertisement advertisement, Placement placement, JsonObject adMarkup) throws IllegalArgumentException {
        HeaderBiddingCallback bidTokenCallBack = this.runtimeValues.headerBiddingCallback.get();
        try {
            int state;
            Advertisement advertisementInDB;
            if (this.visionController.isEnabled()) {
                if (JsonUtil.hasNonNull((JsonElement)adMarkup, "data_science_cache")) {
                    this.visionController.setDataScienceCache(adMarkup.get("data_science_cache").getAsString());
                } else {
                    this.visionController.setDataScienceCache(null);
                }
            }
            if ((advertisementInDB = this.repository.load(advertisement.getId(), Advertisement.class).get()) != null && ((state = advertisementInDB.getState()) == 0 || state == 1 || state == 2)) {
                Log.d((String)TAG, (String)"Operation Cancelled");
                this.onDownloadFailed(new VungleException(25), op.request, null);
                return;
            }
            if (placement.isHeaderBidding() && bidTokenCallBack != null) {
                bidTokenCallBack.onBidTokenAvailable(op.request.getPlacementId(), advertisement.getBidToken());
            }
            this.repository.deleteAdvertisement(advertisement.getId());
            Set<Map.Entry<String, String>> entries = advertisement.getDownloadableUrls().entrySet();
            File destinationDir = this.getDestinationDir(advertisement);
            if (destinationDir == null || !destinationDir.isDirectory()) {
                VungleLogger.error(FETCH_AD_METADATA_CONTEXT, String.format("Response was successful, but adv directory is %1$s; op.request = %2$s, ad.getId() = %3$s", destinationDir == null ? "null" : NOT_A_DIR, op.request, advertisement.getId()));
                this.onDownloadFailed(new VungleException(26), op.request, advertisement.getId());
                return;
            }
            for (Map.Entry<String, String> entry : entries) {
                if (this.isUrlValid(entry.getValue())) {
                    this.saveAsset(advertisement, destinationDir, entry.getKey(), entry.getValue());
                    continue;
                }
                VungleLogger.error(FETCH_AD_METADATA_CONTEXT, String.format("Response was successful, but one of downloadable urls is neither http nor https : url = %1$s; op.request = %2$s, ad.getId() = %3$s", entry.getValue(), op.request, advertisement.getId()));
                this.onDownloadFailed(new VungleException(11), op.request, advertisement.getId());
                return;
            }
            if (!(placement.getPlacementAdType() != 1 || advertisement.getAdType() == 1 && "banner".equals(advertisement.getTemplateType()))) {
                VungleLogger.error(FETCH_AD_METADATA_CONTEXT, String.format("Response was successful, but placement is banner while %1$s; op.request = %2$s, ad.getId() = %3$s", advertisement.getAdType() != 1 ? "ad type is not MRAID" : "advertisement template type is not banner", op.request, advertisement.getId()));
                this.onDownloadFailed(new VungleException(1), op.request, advertisement.getId());
                return;
            }
            advertisement.getAdConfig().setAdSize(op.size);
            advertisement.setAdRequestStartTime(requestStartTime);
            advertisement.setAssetDownloadStartTime(System.currentTimeMillis());
            advertisement.setHeaderBidding(placement.isHeaderBidding());
            this.repository.saveAndApplyState(advertisement, op.request.getPlacementId(), 0);
            int type = op.request.getType();
            if (type == 0 || type == 2) {
                this.tryLoadNextInQueue(op.request);
                this.downloadAdAssets(op, advertisement);
            } else if (op.request.getType() == 1) {
                if (this.isReadyForHBP(op, this.repository)) {
                    this.tryLoadNextInQueue(op.request);
                    this.onReady(op.request, placement, null);
                } else {
                    this.fetchAdMetadata(op, placement);
                }
            }
        }
        catch (DatabaseHelper.DBException e2) {
            VungleLogger.error(FETCH_AD_METADATA_CONTEXT, String.format("BadAd - DBException; can't proceed; placement = %1$s; op.request = %2$s; exception = %3$s", placement, op.request, e2));
            this.onDownloadFailed(new VungleException(26), op.request, null);
        }
    }

    @Nullable
    File getDestinationDir(Advertisement advertisement) {
        return this.repository.getAdvertisementAssetDirectory(advertisement.getId()).get();
    }

    void saveAsset(Advertisement advertisement, File destinationDir, String key, String url) throws DatabaseHelper.DBException {
        String path = destinationDir.getPath() + File.separator + key;
        int type = path.endsWith("postroll") || path.endsWith("template") ? 0 : 2;
        AdAsset adAsset = new AdAsset(advertisement.getId(), url, path);
        adAsset.status = 0;
        adAsset.fileType = type;
        try {
            this.repository.save(adAsset);
        }
        catch (DatabaseHelper.DBException e2) {
            VungleLogger.error("AdLoader#saveAsset; loadAd sequence", String.format("Can't save adAsset %1$s; exception = %2$s", adAsset, e2));
            throw e2;
        }
    }

    private void downloadAdAssets(Operation op, Advertisement advertisement) {
        op.requests.clear();
        for (Map.Entry<String, String> entry : advertisement.getDownloadableUrls().entrySet()) {
            if (!TextUtils.isEmpty((CharSequence)entry.getKey()) && !TextUtils.isEmpty((CharSequence)entry.getValue()) && URLUtil.isValidUrl((String)entry.getValue())) continue;
            VungleLogger.error(DOWNLOAD_AD_ASSETS_CONTEXT, String.format("One or more ad asset URLs is empty or not valid;request = %1$s; advertisement = %2$s", op.request, advertisement));
            this.onDownloadFailed(new VungleException(11), op.request, null);
            Log.e((String)TAG, (String)("Aborting, Failed to download Ad assets for: " + advertisement.getId()));
            return;
        }
        try {
            this.repository.save(advertisement);
        }
        catch (DatabaseHelper.DBException e2) {
            VungleLogger.error(DOWNLOAD_AD_ASSETS_CONTEXT, String.format("Cannot save advertisement op.request = %1$s; advertisement = %2$s", op.request, advertisement));
            this.onDownloadFailed(new VungleException(26), op.request, advertisement.getId());
            return;
        }
        List<AdAsset> assets = this.repository.loadAllAdAssets(advertisement.getId()).get();
        if (assets == null) {
            VungleLogger.error(DOWNLOAD_AD_ASSETS_CONTEXT, String.format("Cannot load all ad assets; op.request = %1$s; advertisement = %2$s", op.request, advertisement));
            this.onDownloadFailed(new VungleException(26), op.request, advertisement.getId());
            return;
        }
        boolean foundVideoAsset = false;
        for (AdAsset asset : assets) {
            if (asset.status == 3) {
                if (this.fileIsValid(new File(asset.localPath), asset)) {
                    if (!FileUtility.isVideoFile(asset.serverPath)) continue;
                    foundVideoAsset = true;
                    SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.ADS_CACHED).addData(SessionAttribute.EVENT_ID, advertisement.getId()).build());
                    continue;
                }
                if (asset.fileType == 1) {
                    VungleLogger.error(DOWNLOAD_AD_ASSETS_CONTEXT, String.format("Cannot download ad assets - asset filetype is zip_asset;request = %1$s; advertisement = %2$s", op.request, advertisement));
                    this.onDownloadFailed(new VungleException(24), op.request, advertisement.getId());
                    return;
                }
            }
            if (asset.status == 4 && asset.fileType == 0) continue;
            if (TextUtils.isEmpty((CharSequence)asset.serverPath)) {
                VungleLogger.error(DOWNLOAD_AD_ASSETS_CONTEXT, String.format("Cannot download ad assets - empty ;request = %1$s; advertisement = %2$s", op.request, advertisement));
                this.onDownloadFailed(new VungleException(24), op.request, advertisement.getId());
                return;
            }
            DownloadRequest downloadRequest = this.getDownloadRequest(op.priority, asset, advertisement.getId());
            if (asset.status == 1) {
                this.downloader.cancelAndAwait(downloadRequest, 1000L);
                downloadRequest = this.getDownloadRequest(op.priority, asset, advertisement.getId());
            }
            Log.d((String)TAG, (String)("Starting download for " + asset));
            asset.status = 1;
            try {
                this.repository.save(asset);
            }
            catch (DatabaseHelper.DBException e3) {
                VungleLogger.error(DOWNLOAD_AD_ASSETS_CONTEXT, String.format("Can't save asset %1$s; exception = %2$s", asset, e3));
                this.onDownloadFailed(new VungleException(26), op.request, advertisement.getId());
                return;
            }
            op.requests.add(downloadRequest);
            if (!FileUtility.isVideoFile(asset.serverPath)) continue;
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.ADS_CACHED).addData(SessionAttribute.EVENT_ID, advertisement.getId()).addData(SessionAttribute.URL, asset.serverPath).build());
            foundVideoAsset = true;
        }
        if (!foundVideoAsset) {
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.ADS_CACHED).addData(SessionAttribute.EVENT_ID, advertisement.getId()).addData(SessionAttribute.VIDEO_CACHED, SessionConstants.NONE).build());
        }
        if (op.requests.size() == 0) {
            this.onAssetDownloadFinished(op, advertisement.getId(), Collections.emptyList(), true);
            return;
        }
        VungleLogger.verbose(true, TAG, TT_DOWNLOAD_CONTEXT, String.format("Start to download assets,  request = %1$s at: %2$d", op.request, System.currentTimeMillis()));
        AssetDownloadListener downloadListener = this.getAssetDownloadListener(advertisement, op);
        for (DownloadRequest downloadRequest : op.requests) {
            this.downloader.download(downloadRequest, downloadListener);
        }
    }

    private DownloadRequest getDownloadRequest(@Priority int priority, AdAsset asset, String advertisementId) {
        AssetPriority assetPriority = this.getAssetPriority(priority, asset.localPath);
        return new DownloadRequest(3, assetPriority, asset.serverPath, asset.localPath, false, asset.identifier, advertisementId);
    }

    private AssetPriority getAssetPriority(@Priority int priority, @NonNull String assetPath) {
        int firstPriority = Math.max(-2147483646, priority);
        int secondPriority = AdLoader.getAssetPriority(assetPath, this.adLoadOptimizationEnabled);
        return new AssetPriority(firstPriority, secondPriority);
    }

    @DownloadRequest.Priority
    public static int getAssetPriority(@NonNull String path, boolean enableAdLoadOpt) {
        if (!enableAdLoadOpt) {
            return 0;
        }
        int secondPriority = 1;
        if (path.endsWith("template")) {
            secondPriority = 0;
        }
        return secondPriority;
    }

    @NonNull
    private AssetDownloadListener getAssetDownloadListener(final Advertisement advertisement, final Operation op) {
        return new AssetDownloadListener(){
            AtomicLong downloadCount;
            List<AssetDownloadListener.DownloadError> errors;
            {
                this.downloadCount = new AtomicLong(op.requests.size());
                this.errors = Collections.synchronizedList(new ArrayList());
            }

            @Override
            public void onError(final @NonNull AssetDownloadListener.DownloadError downloadError, final @Nullable DownloadRequest downloadRequest) {
                AdLoader.this.sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        Log.e((String)TAG, (String)"Download Failed");
                        if (downloadRequest != null) {
                            AdAsset asset;
                            String id2 = downloadRequest.cookieString;
                            AdAsset adAsset = asset = TextUtils.isEmpty((CharSequence)id2) ? null : AdLoader.this.repository.load(id2, AdAsset.class).get();
                            if (asset != null) {
                                errors.add(downloadError);
                                asset.status = 2;
                                try {
                                    AdLoader.this.repository.save(asset);
                                }
                                catch (DatabaseHelper.DBException e2) {
                                    errors.add(new AssetDownloadListener.DownloadError(-1, new VungleException(26), 4));
                                }
                            } else {
                                errors.add(new AssetDownloadListener.DownloadError(-1, new IOException("Downloaded file not found!"), 1));
                            }
                        } else {
                            errors.add(new AssetDownloadListener.DownloadError(-1, new RuntimeException("error in request"), 4));
                        }
                        if (downloadCount.decrementAndGet() <= 0L) {
                            AdLoader.this.onAssetDownloadFinished(op, advertisement.getId(), errors, true);
                        }
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        AdLoader.this.onCriticalFail(39, op.request);
                    }
                });
            }

            @Override
            public void onProgress(@NonNull AssetDownloadListener.Progress progress, @NonNull DownloadRequest downloadRequest) {
            }

            @Override
            public void onSuccess(final @NonNull File downloadedFile, final @NonNull DownloadRequest downloadRequest) {
                AdLoader.this.sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        AdAsset adAsset;
                        if (!downloadedFile.exists()) {
                            VungleLogger.error(AdLoader.GET_ASSET_DOWNLOAD_LISTENER_CONTEXT, String.format("Downloaded file %1$s doesn't exist", downloadedFile.getPath()));
                            this.onError(new AssetDownloadListener.DownloadError(-1, new IOException("Downloaded file not found!"), 3), downloadRequest);
                            return;
                        }
                        String id2 = downloadRequest.cookieString;
                        AdAsset adAsset2 = adAsset = id2 == null ? null : AdLoader.this.repository.load(id2, AdAsset.class).get();
                        if (adAsset == null) {
                            VungleLogger.error(AdLoader.GET_ASSET_DOWNLOAD_LISTENER_CONTEXT, String.format("adAsset is null because %1$s, downloadRequest = %2$s", id2 == null ? "id is null" : "repository returned null", downloadRequest));
                            this.onError(new AssetDownloadListener.DownloadError(-1, new IOException("Downloaded file not found!"), 1), downloadRequest);
                            return;
                        }
                        adAsset.fileType = AdLoader.this.isZip(downloadedFile) ? 0 : 2;
                        adAsset.fileSize = downloadedFile.length();
                        adAsset.status = 3;
                        try {
                            AdLoader.this.repository.save(adAsset);
                        }
                        catch (DatabaseHelper.DBException e2) {
                            VungleLogger.error(AdLoader.GET_ASSET_DOWNLOAD_LISTENER_CONTEXT, String.format("Can't save adAsset %1$s; exception = %2$s", adAsset, e2));
                            this.onError(new AssetDownloadListener.DownloadError(-1, new VungleException(26), 4), downloadRequest);
                            return;
                        }
                        if (AdLoader.this.isZip(downloadedFile)) {
                            AdLoader.this.injectOMIfNeeded(op, advertisement);
                            AdLoader.this.processTemplate(op, adAsset, advertisement);
                        }
                        if (downloadCount.decrementAndGet() <= 0L) {
                            boolean isNeedTriggerCallback = advertisement.isNativeTemplateType() || !AdLoader.this.isAdLoadOptimizationEnabled(advertisement);
                            AdLoader.this.onAssetDownloadFinished(op, advertisement.getId(), errors, isNeedTriggerCallback);
                        }
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        AdLoader.this.onCriticalFail(39, op.request);
                    }
                });
            }
        };
    }

    private boolean isZip(File downloadedFile) {
        return downloadedFile.getName().equals("postroll") || downloadedFile.getName().equals("template");
    }

    private boolean isUrlValid(String url) {
        return !TextUtils.isEmpty((CharSequence)url) && (URLUtil.isHttpsUrl((String)url) || URLUtil.isHttpUrl((String)url));
    }

    private void processTemplate(@NonNull Operation op, @NonNull AdAsset asset, @NonNull Advertisement advertisement) {
        if (asset.status != 3) {
            this.onDownloadFailed(new VungleException(24), op.request, advertisement.getId());
            return;
        }
        File f2 = new File(asset.localPath);
        if (!this.fileIsValid(f2, asset)) {
            VungleLogger.error(ON_ASSET_DOWNLOAD_FINISHED_CONTEXT, String.format("Assets file not valid %1$s; asset = %2$s,request = %3$s; advertisement = %4$s", f2.getPath(), asset.toString(), op.request, advertisement));
            this.onDownloadFailed(new VungleException(24), op.request, advertisement.getId());
            return;
        }
        if (asset.fileType == 0) {
            long unzipStartTime = System.currentTimeMillis();
            VungleLogger.verbose(true, TAG, TT_DOWNLOAD_CONTEXT, String.format("Start to unzip assets, request  = %1$s, at: %2$d", op.request, unzipStartTime));
            try {
                List<AdAsset> assets = this.repository.loadAllAdAssets(advertisement.getId()).get();
                this.unzipFile(advertisement, asset, f2, assets);
            }
            catch (IOException e2) {
                VungleLogger.error(ON_ASSET_DOWNLOAD_FINISHED_CONTEXT, String.format("Unzip failed %1$s; asset = %2$s,request = %3$s; advertisement = %4$s", f2.getPath(), asset.toString(), op.request, advertisement));
                this.downloader.dropCache(asset.serverPath);
                this.onDownloadFailed(new VungleException(24), op.request, advertisement.getId());
                return;
            }
            catch (DatabaseHelper.DBException e3) {
                VungleLogger.error(ON_ASSET_DOWNLOAD_FINISHED_CONTEXT, String.format("Issue(s) with database: exception = %1$s; asset = %2$s,request = %3$s; advertisement = %4$s", e3, asset.toString(), op.request, advertisement));
                this.onDownloadFailed(new VungleException(26), op.request, advertisement.getId());
                return;
            }
            VungleLogger.verbose(true, TAG, TT_DOWNLOAD_CONTEXT, String.format("Unzip assets completed, request  = %1$s, elapsed time = %2$dms", op.request, System.currentTimeMillis() - unzipStartTime));
        }
        if (this.isAdLoadOptimizationEnabled(advertisement)) {
            VungleLogger.verbose(true, TAG, TT_DOWNLOAD_CONTEXT, String.format("Ad ready to play, request  = %1$s, elapsed time = %2$dms", op.request, System.currentTimeMillis() - advertisement.adRequestStartTime));
            this.onDownloadCompleted(op.request, advertisement.getId());
        }
    }

    private boolean injectOMIfNeeded(@NonNull Operation op, @NonNull Advertisement advertisement) {
        if (advertisement.getOmEnabled()) {
            try {
                File destinationDir = this.getDestinationDir(advertisement);
                if (destinationDir == null || !destinationDir.isDirectory()) {
                    VungleLogger.error(ON_ASSET_DOWNLOAD_FINISHED_CONTEXT, String.format("Mraid ad; bad destinationDir - %1$srequest = %2$s; advertisement = %3$s", destinationDir == null ? "null" : NOT_A_DIR, op.request, advertisement));
                    this.onDownloadFailed(new VungleException(26), op.request, advertisement.getId());
                    return false;
                }
                List<File> injected = this.omInjector.injectJsFiles(destinationDir);
                for (File file : injected) {
                    AdAsset asset = new AdAsset(advertisement.getId(), null, file.getPath());
                    asset.fileSize = file.length();
                    asset.fileType = 2;
                    asset.status = 3;
                    this.repository.save(asset);
                }
            }
            catch (IOException e2) {
                this.onDownloadFailed(new VungleException(24), op.request, advertisement.getId());
                return false;
            }
            catch (DatabaseHelper.DBException e3) {
                this.onDownloadFailed(new VungleException(26), op.request, advertisement.getId());
                return false;
            }
        }
        return true;
    }

    private void onAssetDownloadFinished(@NonNull Operation op, @NonNull String advertisementId, @NonNull List<AssetDownloadListener.DownloadError> errors, boolean triggerCallback) {
        VungleLogger.verbose(true, TAG, TT_DOWNLOAD_CONTEXT, String.format("Assets download completed, request  = %1$s, at: %2$d", op.request, System.currentTimeMillis()));
        if (errors.isEmpty()) {
            Advertisement advertisement = this.repository.load(advertisementId, Advertisement.class).get();
            if (advertisement == null) {
                VungleLogger.error(DOWNLOAD_AD_CALLBACK_ON_DOWNLOAD_COMPLETED_CONTEXT, String.format("advertisement is null: request = %1$s; advertisementId = %2$s", op.request, advertisementId));
                this.onDownloadFailed(new VungleException(11), op.request, advertisementId);
                return;
            }
            List<AdAsset> assets = this.repository.loadAllAdAssets(advertisementId).get();
            if (assets == null || assets.size() == 0) {
                VungleLogger.error(ON_ASSET_DOWNLOAD_FINISHED_CONTEXT, String.format("Assets are %1$s; request = %2$s; advertisement = %3$s", assets == null ? "null" : "empty", op.request, advertisementId));
                if (triggerCallback) {
                    this.onDownloadFailed(new VungleException(24), op.request, advertisementId);
                }
                return;
            }
            for (AdAsset asset : assets) {
                if (asset.status == 3) {
                    File f2 = new File(asset.localPath);
                    if (this.fileIsValid(f2, asset)) continue;
                    VungleLogger.error(ON_ASSET_DOWNLOAD_FINISHED_CONTEXT, String.format("Assets file not valid %1$s; asset = %2$s,request = %3$s; advertisement = %4$s", f2.getPath(), asset.toString(), op.request, advertisement));
                    if (triggerCallback) {
                        this.onDownloadFailed(new VungleException(24), op.request, advertisement.getId());
                    }
                    return;
                }
                if (asset.fileType != 0 || asset.status == 4) continue;
                VungleLogger.error(ON_ASSET_DOWNLOAD_FINISHED_CONTEXT, String.format("Zip asset left unprocessed asset = %1$s,request = %2$s; advertisement = %3$s", asset.toString(), op.request, advertisement));
                this.onDownloadFailed(new VungleException(24), op.request, advertisement.getId());
                return;
            }
            if (advertisement.getAdType() == 1) {
                File destinationDir = this.getDestinationDir(advertisement);
                if (destinationDir == null || !destinationDir.isDirectory()) {
                    VungleLogger.error(ON_ASSET_DOWNLOAD_FINISHED_CONTEXT, String.format("Mraid ad; bad destinationDir - %1$srequest = %2$s; advertisement = %3$s", destinationDir == null ? "null" : NOT_A_DIR, op.request, advertisement));
                    if (triggerCallback) {
                        this.onDownloadFailed(new VungleException(26), op.request, advertisement.getId());
                    }
                    return;
                }
                Log.d((String)TAG, (String)("saving MRAID for " + advertisement.getId()));
                advertisement.setMraidAssetDir(destinationDir);
                try {
                    this.repository.save(advertisement);
                }
                catch (DatabaseHelper.DBException e2) {
                    VungleLogger.error(ON_ASSET_DOWNLOAD_FINISHED_CONTEXT, String.format("Issue(s) with database: can't save advertisement;exception = %1$s; request = %2$s; advertisement = %3$s", e2, op.request, advertisement));
                    if (triggerCallback) {
                        this.onDownloadFailed(new VungleException(26), op.request, advertisement.getId());
                    }
                    return;
                }
            }
            if (triggerCallback) {
                this.onDownloadCompleted(op.request, advertisement.getId());
            }
        } else {
            VungleException endError = null;
            for (AssetDownloadListener.DownloadError downloadError : errors) {
                if (VungleException.getExceptionCode(downloadError.cause) == 26) {
                    endError = new VungleException(26);
                    break;
                }
                VungleException error = this.recoverableServerCode(downloadError.serverCode) && downloadError.reason == 1 ? new VungleException(23) : (downloadError.reason == 0 ? new VungleException(23) : new VungleException(24));
                endError = error;
                if (endError.getExceptionCode() != 24) continue;
                break;
            }
            VungleException exception = endError;
            if (triggerCallback) {
                this.onDownloadFailed(exception, op.request, advertisementId);
            }
        }
    }

    @WorkerThread
    public void onDownloadCompleted(@NonNull AdRequest request, @NonNull String advertisementId) {
        Advertisement advertisement;
        Log.d((String)TAG, (String)("download completed " + request));
        Placement placement = this.repository.load(request.getPlacementId(), Placement.class).get();
        if (placement == null) {
            VungleLogger.error(DOWNLOAD_AD_CALLBACK_ON_DOWNLOAD_COMPLETED_CONTEXT, String.format("loaded placement is null: request = %1$s; advertisementId = %2$s", request, advertisementId));
            this.onDownloadFailed(new VungleException(13), request, advertisementId);
            return;
        }
        Advertisement advertisement2 = advertisement = TextUtils.isEmpty((CharSequence)advertisementId) ? null : this.repository.load(advertisementId, Advertisement.class).get();
        if (advertisement == null) {
            VungleLogger.error(DOWNLOAD_AD_CALLBACK_ON_DOWNLOAD_COMPLETED_CONTEXT, String.format("advertisement is null: request = %1$s; advertisementId = %2$s", request, advertisementId));
            this.onDownloadFailed(new VungleException(11), request, advertisementId);
            return;
        }
        advertisement.setFinishedDownloadingTime(System.currentTimeMillis());
        try {
            this.repository.saveAndApplyState(advertisement, request.getPlacementId(), 1);
        }
        catch (DatabaseHelper.DBException e2) {
            VungleLogger.error(DOWNLOAD_AD_CALLBACK_ON_DOWNLOAD_COMPLETED_CONTEXT, String.format("Can't save/apply state READY: exception = %1$s;request = %2$s; advertisement = %3$s", e2, request, advertisement));
            this.onDownloadFailed(new VungleException(26), request, advertisementId);
            return;
        }
        this.onReady(request, placement, advertisement);
    }

    @WorkerThread
    public void onReady(@NonNull AdRequest request, @NonNull Placement placement, @Nullable Advertisement advertisement) {
        String advertisementId;
        this.setLoading(request, false);
        HeaderBiddingCallback headerBiddingCallback = this.runtimeValues.headerBiddingCallback.get();
        if (advertisement != null && placement.isHeaderBidding() && headerBiddingCallback != null) {
            headerBiddingCallback.adAvailableForBidToken(request.getPlacementId(), advertisement.getBidToken());
        }
        Log.i((String)TAG, (String)("found already cached valid adv, calling onAdLoad callback for request " + request));
        InitCallback initCallback = this.runtimeValues.initCallback.get();
        int type = request.getType();
        if (placement.isAutoCached() && initCallback != null && (type == 2 || type == 0)) {
            initCallback.onAutoCacheAdAvailable(request.getPlacementId());
        }
        Operation operation = this.loadOperations.remove(request);
        String string = advertisementId = advertisement != null ? advertisement.getId() : null;
        if (operation != null) {
            placement.setAdSize(operation.size);
            try {
                this.repository.save(placement);
            }
            catch (DatabaseHelper.DBException e2) {
                VungleLogger.error("AdLoader#DownloadAdCallback#onReady; loadAd sequence", String.format("Can't save placement: exception = %1$s;placement = %2$s; advertisement = %3$s", e2, placement, advertisement));
                this.onDownloadFailed(new VungleException(26), request, advertisementId);
                return;
            }
            Log.i((String)TAG, (String)("loading took " + (System.currentTimeMillis() - request.timeStamp.get()) + "ms for:" + request));
            if (request.getIsExplicit()) {
                SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.LOAD_AD_END).addData(SessionAttribute.SUCCESS, true).addData(SessionAttribute.PLACEMENT_ID, placement.getId()).build());
            }
            for (LoadAdCallback loadAdCallback : operation.loadAdCallbacks) {
                if (loadAdCallback instanceof LoadNativeAdCallbackWrapper) {
                    LoadNativeAdCallbackWrapper nativeAdCallback = (LoadNativeAdCallbackWrapper)loadAdCallback;
                    nativeAdCallback.onAdLoad(advertisement);
                    continue;
                }
                loadAdCallback.onAdLoad(request.getPlacementId());
            }
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.AD_AVAILABLE).addData(SessionAttribute.EVENT_ID, advertisement != null ? advertisement.getId() : null).addData(SessionAttribute.PLACEMENT_ID, request.getPlacementId()).build());
            if (request.getIsExplicit()) {
                ArrayList<String> notifications = advertisement != null ? advertisement.getWinNotifications() : new ArrayList<String>();
                this.sendWinNotification(operation, notifications);
            }
        }
    }

    @WorkerThread
    public void onDownloadFailed(@NonNull VungleException exception, @NonNull AdRequest request, @Nullable String advertisementId) {
        Advertisement advertisement;
        Operation op = this.loadOperations.remove(request);
        this.tryLoadNextInQueue(request);
        Placement placement = this.repository.load(request.getPlacementId(), Placement.class).get();
        Advertisement advertisement2 = advertisement = advertisementId == null ? null : this.repository.load(advertisementId, Advertisement.class).get();
        if (placement == null) {
            if (advertisement != null) {
                try {
                    this.repository.saveAndApplyState(advertisement, request.getPlacementId(), 4);
                }
                catch (DatabaseHelper.DBException ignored) {
                    exception = new VungleException(26);
                }
            }
            if (op != null) {
                for (LoadAdCallback loadAdCallback : op.loadAdCallbacks) {
                    loadAdCallback.onError(request.getPlacementId(), exception);
                }
            }
            this.setLoading(request, false);
            return;
        }
        if (placement != null && request.getIsExplicit()) {
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.LOAD_AD_END).addData(SessionAttribute.SUCCESS, false).addData(SessionAttribute.PLACEMENT_ID, placement.getId()).build());
        }
        boolean canRetry = false;
        boolean stopInfinite = false;
        int state = 4;
        switch (exception.getExceptionCode()) {
            case 20: 
            case 22: {
                canRetry = true;
                break;
            }
            case 23: {
                if (advertisement == null) break;
                canRetry = true;
                state = 0;
                break;
            }
            case 1: 
            case 14: 
            case 25: 
            case 36: {
                stopInfinite = true;
                break;
            }
        }
        if (op == null || op.logError) {
            Log.e((String)TAG, (String)("Failed to load Ad/Assets for " + request + ". Cause : "), (Throwable)exception);
        }
        this.setLoading(request, false);
        if (op != null) {
            try {
                if (op.policy == 0) {
                    if (op.retry < op.retryLimit && canRetry) {
                        if (advertisement != null) {
                            this.repository.saveAndApplyState(advertisement, request.getPlacementId(), state);
                        }
                        this.load(op.delay(op.retryDelay).retryDelay(op.retryDelay * 2L).retry(op.retry + 1));
                        return;
                    }
                } else if (op.policy == 1 && !stopInfinite) {
                    int retry = op.retry;
                    if (retry < op.retryLimit && canRetry) {
                        ++retry;
                    } else {
                        retry = 0;
                        state = 4;
                    }
                    if (advertisement != null) {
                        this.repository.saveAndApplyState(advertisement, request.getPlacementId(), state);
                    }
                    this.load(op.delay(op.retryDelay).retryDelay(op.retryDelay * 2L).retry(retry));
                    return;
                }
                if (advertisement != null) {
                    this.repository.saveAndApplyState(advertisement, request.getPlacementId(), 4);
                }
            }
            catch (DatabaseHelper.DBException e2) {
                exception = new VungleException(26);
            }
            for (LoadAdCallback loadAdCallback : op.loadAdCallbacks) {
                loadAdCallback.onError(request.getPlacementId(), exception);
            }
        }
    }

    public void onCriticalFail(@VungleException.ExceptionCode int code, @NonNull AdRequest request) {
        Operation op = this.loadOperations.remove(request);
        this.onError(op, code);
    }

    public void load(AdRequest request, AdConfig adConfig, LoadAdCallback listener) {
        this.load(new Operation(request, adConfig.getAdSize(), 0L, 2000L, 5, 0, 0, true, 0, listener));
    }

    public void loadEndlessIfNeeded(@NonNull Placement placement, @NonNull AdConfig.AdSize size, long delay, boolean isExplicit) {
        if (placement.isMultipleHBPEnabled() && placement.getPlacementAdType() == 1 && !AdConfig.AdSize.isBannerAdSize(size)) {
            size = placement.getRecommendedAdSize();
        }
        if (this.isSizeInvalid(placement, size)) {
            return;
        }
        int priority = placement.getAutoCachePriority();
        VungleSettings settings = this.runtimeValues.settings.get();
        if (settings != null && placement.getId().equals(settings.getPriorityPlacement())) {
            priority = 0;
        }
        AdRequest request = null;
        if (placement.isMultipleHBPEnabled() && !placement.isSingleHBPEnabled()) {
            request = new AdRequest(placement.getId(), 1, placement.getMaxHbCache(), isExplicit);
        } else if (placement.isSingleHBPEnabled()) {
            request = new AdRequest(placement.getId(), 2, 1L, isExplicit);
        } else if (placement.isAutoCached()) {
            request = new AdRequest(placement.getId(), 0, 1L, isExplicit);
        }
        if (request != null) {
            this.load(new Operation(request, size, delay, 2000L, 5, 1, 0, false, priority, new LoadAdCallback[0]));
        }
    }

    private void unzipFile(Advertisement advertisement, AdAsset zipAsset, final @NonNull File downloadedFile, List<AdAsset> allAssets) throws IOException, DatabaseHelper.DBException {
        File mraidJS;
        final ArrayList<String> existingPaths = new ArrayList<String>();
        for (AdAsset asset : allAssets) {
            if (asset.fileType != 2) continue;
            existingPaths.add(asset.localPath);
        }
        File destinationDir = this.getDestinationDir(advertisement);
        if (destinationDir == null || !destinationDir.isDirectory()) {
            VungleLogger.error("AdLoader#unzipFile; loadAd sequence", String.format("Can't unzip file: destination dir is %1$s; advertisement = %2$s", destinationDir == null ? "null" : NOT_A_DIR, advertisement));
            throw new IOException("Unable to access Destination Directory");
        }
        List<File> extractedFiles = UnzipUtility.unzip(downloadedFile.getPath(), destinationDir.getPath(), new UnzipUtility.Filter(){

            @Override
            public boolean matches(String extractPath) {
                File toExtract = new File(extractPath);
                for (String existing : existingPaths) {
                    File existingFile = new File(existing);
                    if (existingFile.equals(toExtract)) {
                        return false;
                    }
                    if (!toExtract.getPath().startsWith(existingFile.getPath() + File.separator)) continue;
                    return false;
                }
                return true;
            }
        });
        if (downloadedFile.getName().equals("template") && (mraidJS = new File(destinationDir.getPath() + File.separator + "mraid.js")).exists()) {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(mraidJS, true)));
            HackMraid.apply(out);
            out.close();
        }
        for (File file : extractedFiles) {
            AdAsset extractedAsset = new AdAsset(advertisement.getId(), null, file.getPath());
            extractedAsset.fileSize = file.length();
            extractedAsset.fileType = 1;
            extractedAsset.parentId = zipAsset.identifier;
            extractedAsset.status = 3;
            this.repository.save(extractedAsset);
        }
        Log.d((String)TAG, (String)("Uzipped " + destinationDir));
        FileUtility.printDirectoryTree(destinationDir);
        zipAsset.status = 4;
        this.repository.save(zipAsset, new Repository.SaveCallback(){

            @Override
            public void onSaved() {
                AdLoader.this.sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileUtility.delete(downloadedFile);
                        }
                        catch (IOException e2) {
                            Log.e((String)TAG, (String)"Error on deleting zip assets archive", (Throwable)e2);
                        }
                    }
                });
            }

            @Override
            public void onError(Exception ignored) {
            }
        });
    }

    boolean hasAssetsFor(Advertisement advertisement) throws IllegalStateException {
        if (advertisement == null) {
            return false;
        }
        List<AdAsset> adAssets = this.repository.loadAllAdAssets(advertisement.getId()).get();
        if (adAssets == null || adAssets.size() == 0) {
            return false;
        }
        boolean isAllAssetAvailable = true;
        for (AdAsset adAsset : adAssets) {
            if (adAsset.fileType == 0) {
                if (adAsset.status == 4) continue;
                isAllAssetAvailable = false;
                break;
            }
            if (this.isUrlValid(adAsset.serverPath) && this.isAdLoadOptimizationEnabled(advertisement)) continue;
            if (adAsset.status != 3) {
                isAllAssetAvailable = false;
                break;
            }
            File file = new File(adAsset.localPath);
            if (this.fileIsValid(file, adAsset)) continue;
            isAllAssetAvailable = false;
            break;
        }
        return isAllAssetAvailable;
    }

    public boolean isAdLoadOptimizationEnabled(Advertisement advertisement) {
        return this.adLoadOptimizationEnabled && advertisement != null && advertisement.getAdType() == 1;
    }

    void sendWinNotification(Operation op, List<String> notifications) {
        if (notifications.isEmpty()) {
            return;
        }
        JobRunner jobRunner = this.jobRunnerRef.get();
        if (jobRunner == null) {
            VungleLogger.error("AdLoader#load; loadAd sequence", String.format("Cannot load operation %s; job runner is null", op));
            this.onError(op, 9);
            return;
        }
        new JobDelegateAnalytics(jobRunner).ping(notifications.toArray(new String[0]));
    }

    private boolean fileIsValid(File file, AdAsset adAsset) {
        return file.exists() && file.length() == adAsset.fileSize;
    }

    @VisibleForTesting
    Collection<Operation> getPendingOperations() {
        return this.pendingOperations.values();
    }

    @VisibleForTesting
    Collection<Operation> getRunningOperations() {
        return this.loadOperations.values();
    }

    void setAdLoadOptimizationEnabled(boolean enabled) {
        this.adLoadOptimizationEnabled = enabled;
    }

    public void dropCache(String advertisementId) {
        List<AdAsset> adAssets = this.repository.loadAllAdAssets(advertisementId).get();
        if (adAssets == null) {
            Log.w((String)TAG, (String)"No assets found in ad cache to cleanup");
            return;
        }
        HashSet<String> urls = new HashSet<String>();
        for (AdAsset asset : adAssets) {
            urls.add(asset.serverPath);
        }
        Advertisement advertisement = this.repository.load(advertisementId, Advertisement.class).get();
        if (advertisement != null) {
            urls.addAll(advertisement.getDownloadableUrls().values());
        }
        for (String url : urls) {
            this.downloader.dropCache(url);
        }
    }

    public static class Operation {
        @NonNull
        final AdRequest request;
        @NonNull
        final AdConfig.AdSize size;
        long delay;
        long retryDelay;
        int retry;
        int retryLimit;
        int policy;
        @NonNull
        final Set<LoadAdCallback> loadAdCallbacks = new CopyOnWriteArraySet<LoadAdCallback>();
        @NonNull
        final AtomicBoolean loading;
        boolean logError;
        @Priority
        int priority;
        List<DownloadRequest> requests = new CopyOnWriteArrayList<DownloadRequest>();

        public Operation(@NonNull AdRequest request, @NonNull AdConfig.AdSize size, long delay, long retryDelay, int retryLimit, int policy, int retry, boolean logError, @Priority int priority, LoadAdCallback ... loadAdCallbacks) {
            this.request = request;
            this.delay = delay;
            this.retryDelay = retryDelay;
            this.retryLimit = retryLimit;
            this.policy = policy;
            this.retry = retry;
            this.loading = new AtomicBoolean();
            this.size = size;
            this.logError = logError;
            this.priority = priority;
            if (loadAdCallbacks != null) {
                this.loadAdCallbacks.addAll(Arrays.asList(loadAdCallbacks));
            }
        }

        Operation delay(long delay) {
            return new Operation(this.request, this.size, delay, this.retryDelay, this.retryLimit, this.policy, this.retry, this.logError, this.priority, this.loadAdCallbacks.toArray(new LoadAdCallback[0]));
        }

        Operation retryDelay(long retryDelay) {
            return new Operation(this.request, this.size, this.delay, retryDelay, this.retryLimit, this.policy, this.retry, this.logError, this.priority, this.loadAdCallbacks.toArray(new LoadAdCallback[0]));
        }

        Operation retry(int retry) {
            return new Operation(this.request, this.size, this.delay, this.retryDelay, this.retryLimit, this.policy, retry, this.logError, this.priority, this.loadAdCallbacks.toArray(new LoadAdCallback[0]));
        }

        void merge(Operation other) {
            this.delay = Math.min(this.delay, other.delay);
            this.retryDelay = Math.min(this.retryDelay, other.retryDelay);
            this.retryLimit = Math.min(this.retryLimit, other.retryLimit);
            this.policy = other.policy == 0 ? other.policy : this.policy;
            this.retry = Math.min(this.retry, other.retry);
            this.logError |= other.logError;
            this.priority = Math.min(this.priority, other.priority);
            this.loadAdCallbacks.addAll(other.loadAdCallbacks);
        }

        @NonNull
        public String toString() {
            return "request=" + this.request.toString() + " size=" + this.size.toString() + " priority=" + this.priority + " policy=" + this.policy + " retry=" + this.retry + "/" + this.retryLimit + " delay=" + this.delay + "->" + this.retryDelay + " log=" + this.logError;
        }

        @VisibleForTesting
        @NonNull
        public AdRequest getRequest() {
            return this.request;
        }

        @NonNull
        public AdConfig.AdSize getSize() {
            return this.size;
        }

        public boolean getLogError() {
            return this.logError;
        }

        @Priority
        public int getPriority() {
            return this.priority;
        }
    }

    public static @interface Priority {
        public static final int HIGHEST = 0;
        public static final int HIGH = 1;
        public static final int LOWEST = Integer.MAX_VALUE;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ReschedulePolicy {
        public static final int EXPONENTIAL = 0;
        public static final int EXPONENTIAL_ENDLESS_AD = 1;
    }
}

