/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.model.admarkup.AdMarkup;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public final class AdRequest
implements Serializable {
    private final boolean isExplicit;
    @NonNull
    private final String placementId;
    @Nullable
    private final AdMarkup adMarkup;
    @Type
    private final int type;
    private final long adCount;
    public AtomicLong timeStamp = new AtomicLong(0L);

    public AdRequest(@NonNull String placementId, @Type int type, long adCount, boolean isExplicit) {
        this.placementId = placementId;
        this.adMarkup = null;
        this.type = type;
        this.adCount = adCount;
        this.isExplicit = isExplicit;
    }

    public AdRequest(@NonNull String placementId, @Nullable AdMarkup adMarkup, boolean isExplicit) {
        this.placementId = placementId;
        this.adMarkup = adMarkup;
        this.type = 0;
        this.adCount = 1L;
        this.isExplicit = isExplicit;
    }

    public AdRequest(@NonNull String placementId, boolean isExplicit) {
        this(placementId, null, isExplicit);
    }

    @NonNull
    public String getPlacementId() {
        return this.placementId;
    }

    @Nullable
    public String getEventId() {
        return this.adMarkup == null ? null : this.adMarkup.getEventId();
    }

    @Nullable
    public String[] getImpression() {
        AdMarkup adMarkup = this.getAdMarkup();
        return adMarkup != null ? this.getAdMarkup().getImpressions() : null;
    }

    @Type
    public int getType() {
        return this.type;
    }

    public long getAdCount() {
        return this.adCount;
    }

    @Nullable
    public AdMarkup getAdMarkup() {
        return this.adMarkup;
    }

    @Nullable
    public boolean getIsExplicit() {
        return this.isExplicit;
    }

    public String toString() {
        return "AdRequest{placementId='" + this.placementId + '\'' + ", adMarkup=" + this.adMarkup + ", type=" + this.type + ", adCount=" + this.adCount + ", isExplicit=" + this.isExplicit + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdRequest request = (AdRequest)o;
        if (this.type != request.type) {
            return false;
        }
        if (!this.placementId.equals(request.placementId)) {
            return false;
        }
        return this.adMarkup != null ? this.adMarkup.equals(request.adMarkup) : request.adMarkup == null;
    }

    public int hashCode() {
        int result = this.placementId.hashCode();
        result = 31 * result + (this.adMarkup != null ? this.adMarkup.hashCode() : 0);
        result = 31 * result + this.type;
        return result;
    }

    public static @interface Type {
        public static final int NORMAL = 0;
        public static final int NO_ASSETS = 1;
        public static final int SINGLE_HBP = 2;
    }
}

