/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.vungle.warren.AdConfig;
import com.vungle.warren.Vungle;
import com.vungle.warren.analytics.AdAnalytics;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.utility.ViewUtility;
import java.util.regex.Pattern;

public class ClickCoordinateTracker {
    private static final int DEFAULT_WIDTH_HEIGHT = 0;
    private static final String MACRO_REQ_WIDTH = Pattern.quote("{{{req_width}}}");
    private static final String MACRO_REQ_HEIGHT = Pattern.quote("{{{req_height}}}");
    private static final String MACRO_WIDTH = Pattern.quote("{{{width}}}");
    private static final String MACRO_HEIGHT = Pattern.quote("{{{height}}}");
    private static final String MACRO_DOWN_X = Pattern.quote("{{{down_x}}}");
    private static final String MACRO_DOWN_Y = Pattern.quote("{{{down_y}}}");
    private static final String MACRO_UP_X = Pattern.quote("{{{up_x}}}");
    private static final String MACRO_UP_Y = Pattern.quote("{{{up_y}}}");
    private final Advertisement advertisement;
    private final AdAnalytics adAnalytics;
    @VisibleForTesting
    ClickCoordinate currentClick;

    public ClickCoordinateTracker(@NonNull Advertisement advertisement, @NonNull AdAnalytics analytics) {
        this.advertisement = advertisement;
        this.adAnalytics = analytics;
    }

    public void trackCoordinate(MotionEvent event) {
        if (!this.advertisement.isClickCoordinatesTrackingEnabled()) {
            return;
        }
        if (this.currentClick == null) {
            this.currentClick = new ClickCoordinate();
        }
        switch (event.getAction()) {
            case 0: {
                this.currentClick.setDownCoordinate(new Coordinate((int)event.getX(), (int)event.getY()));
                break;
            }
            case 1: {
                this.currentClick.setUpCoordinate(new Coordinate((int)event.getX(), (int)event.getY()));
                if (!this.currentClick.ready()) break;
                this.sendClickCoordinates();
                break;
            }
        }
    }

    private void sendClickCoordinates() {
        if (this.adAnalytics != null) {
            String[] tpatUrls = this.advertisement.getTpatUrls("video.clickCoordinates");
            if (tpatUrls == null || tpatUrls.length == 0) {
                return;
            }
            int reqWidth = this.getRequestWidth();
            int reqHeight = this.getRequestHeight();
            int adWidth = this.getRequestWidth();
            int adHeight = this.getRequestHeight();
            for (int i = 0; i < tpatUrls.length; ++i) {
                String tpat = tpatUrls[i];
                if (TextUtils.isEmpty((CharSequence)tpat)) continue;
                tpatUrls[i] = tpat = tpat.replaceAll(MACRO_REQ_WIDTH, Integer.toString(reqWidth)).replaceAll(MACRO_REQ_HEIGHT, Integer.toString(reqHeight)).replaceAll(MACRO_WIDTH, Integer.toString(adWidth)).replaceAll(MACRO_HEIGHT, Integer.toString(adHeight)).replaceAll(MACRO_DOWN_X, Integer.toString(this.currentClick.downCoordinate.x)).replaceAll(MACRO_DOWN_Y, Integer.toString(this.currentClick.downCoordinate.y)).replaceAll(MACRO_UP_X, Integer.toString(this.currentClick.upCoordinate.x)).replaceAll(MACRO_UP_Y, Integer.toString(this.currentClick.upCoordinate.y));
            }
            this.adAnalytics.ping(tpatUrls);
        }
    }

    private int getRequestWidth() {
        if (Vungle.appContext() != null && this.advertisement.getAdConfig() != null) {
            AdConfig.AdSize adSize = this.advertisement.getAdConfig().getAdSize();
            if (adSize == AdConfig.AdSize.VUNGLE_DEFAULT) {
                return this.getDeviceWidth();
            }
            return ViewUtility.dpToPixels(Vungle.appContext(), adSize.getWidth());
        }
        return 0;
    }

    private int getRequestHeight() {
        if (Vungle.appContext() != null && this.advertisement.getAdConfig() != null) {
            AdConfig.AdSize adSize = this.advertisement.getAdConfig().getAdSize();
            if (adSize == AdConfig.AdSize.VUNGLE_DEFAULT) {
                return this.getDeviceHeight();
            }
            return ViewUtility.dpToPixels(Vungle.appContext(), adSize.getHeight());
        }
        return 0;
    }

    private int getDeviceWidth() {
        if (Vungle.appContext() != null) {
            return DeviceScreenInfo.getInstance(Vungle.appContext()).getDeviceWidth();
        }
        return 0;
    }

    private int getDeviceHeight() {
        if (Vungle.appContext() != null) {
            return DeviceScreenInfo.getInstance(Vungle.appContext()).getDeviceHeight();
        }
        return 0;
    }

    public static class DeviceScreenInfo {
        @SuppressLint(value={"StaticFieldLeak"})
        private static DeviceScreenInfo INSTANCE;
        private final Context context;
        private final DisplayMetrics dm;

        private DeviceScreenInfo(@NonNull Context context) {
            this.context = context.getApplicationContext();
            this.dm = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(this.dm);
        }

        public static DeviceScreenInfo getInstance(@NonNull Context context) {
            if (INSTANCE == null) {
                INSTANCE = new DeviceScreenInfo(context);
            }
            return INSTANCE;
        }

        public int getDeviceWidth() {
            return this.dm.widthPixels;
        }

        public int getDeviceHeight() {
            return this.dm.heightPixels;
        }
    }

    static class Coordinate {
        int x;
        int y;

        public Coordinate(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    static class ClickCoordinate {
        Coordinate downCoordinate = new Coordinate(Integer.MIN_VALUE, Integer.MIN_VALUE);
        Coordinate upCoordinate = new Coordinate(Integer.MIN_VALUE, Integer.MIN_VALUE);

        public void setUpCoordinate(Coordinate coordinate) {
            this.upCoordinate = coordinate;
        }

        public void setDownCoordinate(Coordinate coordinate) {
            this.downCoordinate = coordinate;
        }

        public boolean ready() {
            return this.downCoordinate.x != Integer.MIN_VALUE && this.downCoordinate.y != Integer.MIN_VALUE && this.upCoordinate.x != Integer.MIN_VALUE && this.upCoordinate.y != Integer.MIN_VALUE;
        }
    }
}

