/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.AdConfig;
import com.vungle.warren.NativeAd;
import com.vungle.warren.utility.ViewUtility;

class NativeAdOptionsView
extends FrameLayout {
    private static final int AD_OPTIONS_VIEW_SIZE = 20;
    private ImageView icon;

    public NativeAdOptionsView(@NonNull Context context) {
        super(context);
        this.initView(context);
    }

    public NativeAdOptionsView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public NativeAdOptionsView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    private void initView(@NonNull Context context) {
        this.icon = new ImageView(context);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        this.icon.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView((View)this.icon);
    }

    public void renderTo(@NonNull NativeAd nativeAd, @NonNull FrameLayout rootView, @AdConfig.AdOptionsPosition int optionsPosition) {
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
        rootView.addView((View)this);
        String iconUrl = nativeAd.getPrivacyIconUrl();
        nativeAd.displayImage(iconUrl, this.icon);
        nativeAd.registerClickEvent((View)this, 2);
        int size = ViewUtility.dpToPixels(this.getContext(), 20);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(size, size);
        switch (optionsPosition) {
            case 0: {
                params.gravity = 0x800033;
                break;
            }
            case 2: {
                params.gravity = 8388691;
                break;
            }
            case 3: {
                params.gravity = 0x800055;
                break;
            }
            default: {
                params.gravity = 8388661;
            }
        }
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        rootView.requestLayout();
    }

    public void destroy() {
        this.removeAllViews();
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
    }
}

