/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.AdLoader;
import com.vungle.warren.AdRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicInteger;

class OperationSequence {
    private final PriorityQueue<Entry> queue = new PriorityQueue<Entry>(11, new Comparator<Entry>(){

        @Override
        public int compare(Entry e1, Entry e2) {
            int result = Integer.valueOf(e1.operation.priority).compareTo(e2.operation.priority);
            if (result == 0) {
                return Integer.valueOf(e1.order).compareTo(e2.order);
            }
            return result;
        }
    });

    OperationSequence() {
    }

    @Nullable
    Entry remove(AdRequest request) {
        Entry entry = null;
        for (Entry op : this.queue) {
            if (!op.operation.request.equals(request)) continue;
            entry = op;
            break;
        }
        this.queue.remove(entry);
        return entry;
    }

    boolean offer(Entry entry) {
        return this.queue.offer(entry);
    }

    Entry poll() {
        return this.queue.poll();
    }

    List<Entry> removeAll() {
        ArrayList<Entry> ops = new ArrayList<Entry>();
        while (!this.queue.isEmpty()) {
            Entry e2 = this.queue.poll();
            if (e2 == null) continue;
            ops.add(e2);
        }
        return ops;
    }

    static class Entry {
        private static final AtomicInteger seq = new AtomicInteger();
        private final int order = seq.incrementAndGet();
        @NonNull
        AdLoader.Operation operation;

        Entry(@NonNull AdLoader.Operation operation) {
            this.operation = operation;
        }
    }
}

