/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.annotation.SuppressLint;
import android.app.UiModeManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.provider.Settings;
import android.security.NetworkSecurityPolicy;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import android.webkit.URLUtil;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.PermissionChecker;
import androidx.core.util.Consumer;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vungle.warren.PrivacyManager;
import com.vungle.warren.ServiceLocator;
import com.vungle.warren.SessionTracker;
import com.vungle.warren.Vungle;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.AdvertisingInfo;
import com.vungle.warren.model.CacheBust;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.model.JsonUtil;
import com.vungle.warren.model.SessionData;
import com.vungle.warren.network.APIFactory;
import com.vungle.warren.network.Call;
import com.vungle.warren.network.Response;
import com.vungle.warren.network.VungleApi;
import com.vungle.warren.omsdk.OMInjector;
import com.vungle.warren.persistence.CacheManager;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.session.SessionAttribute;
import com.vungle.warren.session.SessionEvent;
import com.vungle.warren.utility.TimeoutProvider;
import com.vungle.warren.utility.platform.Platform;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;

public class VungleApiClient {
    private static final String TAG = VungleApiClient.class.getCanonicalName();
    private static final String ID = "id";
    private static final String AMAZON_ADVERTISING_ID = "amazon_advertising_id";
    public static final String GAID = "gaid";
    public static final String ANDROID_ID = "android_id";
    public static final String IFA = "ifa";
    private final Platform platform;
    private Context context;
    private VungleApi api;
    private String newEndpoint;
    private String requestAdEndpoint;
    private String reportAdEndpoint;
    private String willPlayAdEndpoint;
    private String riEndpoint;
    private String logEndpoint;
    private String cacheBustEndpoint;
    private String biLoggingEndpoint;
    private JsonObject baseDeviceInfo;
    private JsonObject appBody;
    private boolean willPlayAdEnabled;
    private int willPlayAdTimeout;
    private OkHttpClient client;
    private VungleApi timeoutApi;
    private VungleApi gzipApi;
    private boolean enableOm;
    private CacheManager cacheManager;
    private Boolean isGooglePlayServicesAvailable;
    private TimeoutProvider timeoutProvider;
    private static String headerUa = ("Amazon".equals(Build.MANUFACTURER) ? "VungleAmazon/" : "VungleDroid/") + "6.12.0";
    private static String BASE_URL = "https://ads.api.vungle.com/";
    protected static WrapperFramework WRAPPER_FRAMEWORK_SELECTED;
    private Map<String, Long> retryAfterDataMap = new ConcurrentHashMap<String, Long>();
    private Repository repository;
    private String uaString = System.getProperty("http.agent");
    private final OMInjector omInjector;
    private static Set<Interceptor> networkInterceptors;
    private static Set<Interceptor> logInterceptors;

    VungleApiClient(@NonNull Context context, @NonNull CacheManager cacheManager, @NonNull Repository repository, @NonNull OMInjector omInjector, @NonNull Platform platform) {
        this.cacheManager = cacheManager;
        this.context = context.getApplicationContext();
        this.repository = repository;
        this.omInjector = omInjector;
        this.platform = platform;
        Interceptor responseInterceptor = new Interceptor(){

            public okhttp3.Response intercept(Interceptor.Chain chain) throws IOException {
                String retryAfterTimeStr;
                int responseCode;
                okhttp3.Response response;
                Request request = chain.request();
                String urlPath = request.url().encodedPath();
                Long retryExpireTime = (Long)VungleApiClient.this.retryAfterDataMap.get(urlPath);
                if (retryExpireTime != null) {
                    long currentTimeStamp = System.currentTimeMillis();
                    long newRetryAfter = TimeUnit.MILLISECONDS.toSeconds(retryExpireTime - currentTimeStamp);
                    if (newRetryAfter > 0L) {
                        return new Response.Builder().request(request).addHeader("Retry-After", String.valueOf(newRetryAfter)).code(500).protocol(Protocol.HTTP_1_1).message("Server is busy").body(ResponseBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)"{\"Error\":\"Retry-After\"}")).build();
                    }
                    VungleApiClient.this.retryAfterDataMap.remove(urlPath);
                }
                if (!((response = chain.proceed(request)) == null || (responseCode = response.code()) != 429 && responseCode != 500 && responseCode != 502 && responseCode != 503 || TextUtils.isEmpty((CharSequence)(retryAfterTimeStr = response.headers().get("Retry-After"))))) {
                    try {
                        long retryAfterTimeValue = Long.parseLong(retryAfterTimeStr);
                        if (retryAfterTimeValue > 0L) {
                            VungleApiClient.this.retryAfterDataMap.put(urlPath, retryAfterTimeValue * 1000L + System.currentTimeMillis());
                        }
                    }
                    catch (NumberFormatException e2) {
                        Log.d((String)TAG, (String)"Retry-After value is not an valid value");
                    }
                }
                return response;
            }
        };
        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor(responseInterceptor);
        this.client = builder.build();
        OkHttpClient gzipClient = builder.addInterceptor((Interceptor)new GzipRequestInterceptor()).build();
        this.api = new APIFactory((Call.Factory)this.client, BASE_URL).createAPI(Vungle._instance.appID);
        this.gzipApi = new APIFactory((Call.Factory)gzipClient, BASE_URL).createAPI(Vungle._instance.appID);
        ServiceLocator serviceLocator = ServiceLocator.getInstance(context);
        this.timeoutProvider = serviceLocator.getService(TimeoutProvider.class);
    }

    public static String getHeaderUa() {
        return headerUa;
    }

    public static void setHeaderUa(String headerUa) {
        VungleApiClient.headerUa = headerUa;
    }

    public void init() {
        this.init(this.context);
    }

    @VisibleForTesting
    synchronized void init(Context context) {
        JsonObject app = new JsonObject();
        app.addProperty("bundle", context.getPackageName());
        String versionName = null;
        try {
            versionName = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        app.addProperty("ver", versionName != null ? versionName : "1.0");
        JsonObject device = new JsonObject();
        device.addProperty("make", Build.MANUFACTURER);
        device.addProperty("model", Build.MODEL);
        device.addProperty("osv", Build.VERSION.RELEASE);
        device.addProperty("carrier", ((TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName());
        device.addProperty("os", "Amazon".equals(Build.MANUFACTURER) ? "amazon" : "android");
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(dm);
        device.addProperty("w", (Number)dm.widthPixels);
        device.addProperty("h", (Number)dm.heightPixels);
        try {
            this.uaString = this.platform.getUserAgent();
            device.addProperty("ua", this.uaString);
            this.initUserAgentLazy();
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("Cannot Get UserAgent. Setting Default Device UserAgent." + ex.getLocalizedMessage()));
        }
        this.baseDeviceInfo = device;
        this.appBody = app;
        this.isGooglePlayServicesAvailable = this.getPlayServicesAvailabilityFromAPI();
    }

    void setAppId(String appId) {
        this.setAppId(appId, this.appBody);
    }

    private void setAppId(String appId, JsonObject requestBody) {
        requestBody.addProperty(ID, appId);
    }

    private void initUserAgentLazy() {
        this.platform.getUserAgentLazy(new Consumer<String>(){

            public void accept(String uaString) {
                if (uaString == null) {
                    Log.e((String)TAG, (String)"Cannot Get UserAgent. Setting Default Device UserAgent");
                    return;
                }
                VungleApiClient.this.uaString = uaString;
            }
        });
    }

    public Response config() throws VungleException, IOException {
        Response<JsonObject> response;
        JsonObject body = new JsonObject();
        body.add("device", (JsonElement)this.getDeviceBody(true));
        body.add("app", (JsonElement)this.appBody);
        body.add("user", (JsonElement)this.getUserBody());
        JsonObject extBody = this.getExtBody();
        if (extBody != null) {
            body.add("ext", (JsonElement)extBody);
        }
        if (!(response = this.api.config(VungleApiClient.getHeaderUa(), body).execute()).isSuccessful()) {
            return response;
        }
        JsonObject jsonObject = response.body();
        Log.d((String)TAG, (String)("Config Response: " + jsonObject));
        if (JsonUtil.hasNonNull((JsonElement)jsonObject, "sleep")) {
            String errorMessage = JsonUtil.hasNonNull((JsonElement)jsonObject, "info") ? jsonObject.get("info").getAsString() : "";
            Log.e((String)TAG, (String)("Error Initializing Vungle. Please try again. " + errorMessage));
            throw new VungleException(3);
        }
        if (!JsonUtil.hasNonNull((JsonElement)jsonObject, "endpoints")) {
            Log.e((String)TAG, (String)"Error Initializing Vungle. Please try again. ");
            throw new VungleException(3);
        }
        JsonObject endpoints = jsonObject.getAsJsonObject("endpoints");
        HttpUrl newUrl = HttpUrl.parse((String)endpoints.get("new").getAsString());
        HttpUrl adsUrl = HttpUrl.parse((String)endpoints.get("ads").getAsString());
        HttpUrl willPlayAdUrl = HttpUrl.parse((String)endpoints.get("will_play_ad").getAsString());
        HttpUrl reportAdUrl = HttpUrl.parse((String)endpoints.get("report_ad").getAsString());
        HttpUrl reportIncentivized = HttpUrl.parse((String)endpoints.get("ri").getAsString());
        HttpUrl logUrl = HttpUrl.parse((String)endpoints.get("log").getAsString());
        HttpUrl cacheBustUrl = HttpUrl.parse((String)endpoints.get("cache_bust").getAsString());
        HttpUrl biLoggingUrl = HttpUrl.parse((String)endpoints.get("sdk_bi").getAsString());
        if (newUrl == null || adsUrl == null || willPlayAdUrl == null || reportAdUrl == null || reportIncentivized == null || logUrl == null || cacheBustUrl == null || biLoggingUrl == null) {
            Log.e((String)TAG, (String)"Error Initializing Vungle. Please try again. ");
            throw new VungleException(3);
        }
        this.newEndpoint = newUrl.toString();
        this.requestAdEndpoint = adsUrl.toString();
        this.willPlayAdEndpoint = willPlayAdUrl.toString();
        this.reportAdEndpoint = reportAdUrl.toString();
        this.riEndpoint = reportIncentivized.toString();
        this.logEndpoint = logUrl.toString();
        this.cacheBustEndpoint = cacheBustUrl.toString();
        this.biLoggingEndpoint = biLoggingUrl.toString();
        JsonObject willPlayAd = jsonObject.getAsJsonObject("will_play_ad");
        this.willPlayAdTimeout = willPlayAd.get("request_timeout").getAsInt();
        this.willPlayAdEnabled = willPlayAd.get("enabled").getAsBoolean();
        JsonObject viewability = jsonObject.getAsJsonObject("viewability");
        this.enableOm = JsonUtil.getAsBoolean((JsonElement)viewability, "om", false);
        if (this.willPlayAdEnabled) {
            Log.v((String)TAG, (String)"willPlayAd is enabled, generating a timeout client.");
            OkHttpClient timeoutClient = this.client.newBuilder().readTimeout((long)this.willPlayAdTimeout, TimeUnit.MILLISECONDS).build();
            APIFactory timeoutRetro = new APIFactory((Call.Factory)timeoutClient, "https://api.vungle.com/");
            this.timeoutApi = timeoutRetro.createAPI(Vungle._instance.appID);
        }
        if (this.getOmEnabled()) {
            this.omInjector.init();
        } else {
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.OM_SDK).addData(SessionAttribute.ENABLED, false).build());
        }
        return response;
    }

    public Call<JsonObject> reportNew() throws IllegalStateException {
        if (this.newEndpoint == null) {
            throw new IllegalStateException("API Client not configured yet! Must call /config first.");
        }
        HashMap<String, String> query = new HashMap<String, String>(2);
        JsonElement idElement = this.appBody.get(ID);
        query.put("app_id", idElement != null ? idElement.getAsString() : "");
        JsonObject latestDeviceBody = this.getDeviceBody();
        if (PrivacyManager.getInstance().shouldSendAdIds()) {
            JsonElement ifaElement = latestDeviceBody.get(IFA);
            query.put(IFA, ifaElement != null ? ifaElement.getAsString() : "");
        }
        return this.api.reportNew(VungleApiClient.getHeaderUa(), this.newEndpoint, query);
    }

    public Call<JsonObject> requestAd(String placement, String adSize, boolean isHeaderBiddingEnable, @Nullable JsonObject vision) throws IllegalStateException {
        if (this.requestAdEndpoint == null) {
            throw new IllegalStateException("API Client not configured yet! Must call /config first.");
        }
        JsonObject body = new JsonObject();
        body.add("device", (JsonElement)this.getDeviceBody());
        body.add("app", (JsonElement)this.appBody);
        JsonObject userBody = this.getUserBody();
        if (vision != null) {
            userBody.add("vision", (JsonElement)vision);
        }
        body.add("user", (JsonElement)userBody);
        JsonObject extBody = this.getExtBody();
        if (extBody != null) {
            body.add("ext", (JsonElement)extBody);
        }
        JsonObject request = new JsonObject();
        JsonArray placementsArray = new JsonArray();
        placementsArray.add(placement);
        request.add("placements", (JsonElement)placementsArray);
        request.addProperty("header_bidding", Boolean.valueOf(isHeaderBiddingEnable));
        if (!TextUtils.isEmpty((CharSequence)adSize)) {
            request.addProperty("ad_size", adSize);
        }
        body.add("request", (JsonElement)request);
        return this.gzipApi.ads(VungleApiClient.getHeaderUa(), this.requestAdEndpoint, body);
    }

    Call<JsonObject> willPlayAd(String placementID, boolean autoCached, String adToken) {
        JsonObject body = new JsonObject();
        body.add("device", (JsonElement)this.getDeviceBody());
        body.add("app", (JsonElement)this.appBody);
        body.add("user", (JsonElement)this.getUserBody());
        JsonObject request = new JsonObject();
        JsonObject placement = new JsonObject();
        placement.addProperty("reference_id", placementID);
        placement.addProperty("is_auto_cached", Boolean.valueOf(autoCached));
        request.add("placement", (JsonElement)placement);
        request.addProperty("ad_token", adToken);
        body.add("request", (JsonElement)request);
        return this.timeoutApi.willPlayAd(VungleApiClient.getHeaderUa(), this.willPlayAdEndpoint, body);
    }

    boolean canCallWillPlayAd() {
        return this.willPlayAdEnabled && !TextUtils.isEmpty((CharSequence)this.willPlayAdEndpoint);
    }

    public Call<JsonObject> reportAd(JsonObject request) {
        if (this.reportAdEndpoint == null) {
            throw new IllegalStateException("API Client not configured yet! Must call /config first.");
        }
        JsonObject body = new JsonObject();
        body.add("device", (JsonElement)this.getDeviceBody());
        body.add("app", (JsonElement)this.appBody);
        body.add("request", (JsonElement)request);
        body.add("user", (JsonElement)this.getUserBody());
        JsonObject extBody = this.getExtBody();
        if (extBody != null) {
            body.add("ext", (JsonElement)extBody);
        }
        return this.gzipApi.reportAd(VungleApiClient.getHeaderUa(), this.reportAdEndpoint, body);
    }

    public Call<JsonObject> sendLog(JsonObject request) {
        if (this.logEndpoint == null) {
            throw new IllegalStateException("API Client not configured yet! Must call /config first.");
        }
        return this.gzipApi.sendLog(VungleApiClient.getHeaderUa(), this.logEndpoint, request);
    }

    public Call<JsonObject> ri(JsonObject request) {
        if (this.riEndpoint == null) {
            throw new IllegalStateException("API Client not configured yet! Must call /config first.");
        }
        JsonObject body = new JsonObject();
        body.add("device", (JsonElement)this.getDeviceBody());
        body.add("app", (JsonElement)this.appBody);
        body.add("request", (JsonElement)request);
        body.add("user", (JsonElement)this.getUserBody());
        JsonObject extBody = this.getExtBody();
        if (extBody != null) {
            body.add("ext", (JsonElement)extBody);
        }
        return this.api.ri(VungleApiClient.getHeaderUa(), this.riEndpoint, body);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean pingTPAT(String url) throws ClearTextTrafficException, MalformedURLException {
        if (!TextUtils.isEmpty((CharSequence)url) && HttpUrl.parse((String)url) != null) {
            String host;
            try {
                host = new URL(url).getHost();
            }
            catch (MalformedURLException e2) {
                SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.TPAT).addData(SessionAttribute.SUCCESS, false).addData(SessionAttribute.REASON, "Invalid URL").addData(SessionAttribute.URL, url).build());
                throw new MalformedURLException("Invalid URL : " + url);
            }
            boolean clearTextTrafficPermitted = Build.VERSION.SDK_INT >= 24 ? NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(host) : (Build.VERSION.SDK_INT >= 23 ? NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted() : true);
            if (!clearTextTrafficPermitted && URLUtil.isHttpUrl((String)url)) {
                SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.TPAT).addData(SessionAttribute.SUCCESS, false).addData(SessionAttribute.REASON, "Clear Text Traffic is blocked").addData(SessionAttribute.URL, url).build());
                throw new ClearTextTrafficException("Clear Text Traffic is blocked");
            }
            try {
                Response<Void> response = this.api.pingTPAT(this.uaString, url).execute();
                if (response == null) {
                    SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.TPAT).addData(SessionAttribute.SUCCESS, false).addData(SessionAttribute.REASON, "Error on pinging TPAT").addData(SessionAttribute.URL, url).build());
                    return true;
                }
                if (response.isSuccessful()) return true;
                SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.TPAT).addData(SessionAttribute.SUCCESS, false).addData(SessionAttribute.REASON, response.code() + ": " + response.message()).addData(SessionAttribute.URL, url).build());
                return true;
            }
            catch (IOException e3) {
                SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.TPAT).addData(SessionAttribute.SUCCESS, false).addData(SessionAttribute.REASON, e3.getMessage()).addData(SessionAttribute.URL, url).build());
                Log.d((String)TAG, (String)"Error on pinging TPAT");
                return false;
            }
        }
        SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.TPAT).addData(SessionAttribute.SUCCESS, false).addData(SessionAttribute.REASON, "Invalid URL").addData(SessionAttribute.URL, url).build());
        throw new MalformedURLException("Invalid URL : " + url);
    }

    public Call<JsonObject> cacheBust(long lastCacheBustTime) {
        if (this.cacheBustEndpoint == null) {
            throw new IllegalStateException("API Client not configured yet! Must call /config first.");
        }
        JsonObject body = new JsonObject();
        body.add("device", (JsonElement)this.getDeviceBody());
        body.add("app", (JsonElement)this.appBody);
        JsonObject userBody = this.getUserBody();
        body.add("user", (JsonElement)userBody);
        JsonObject request = new JsonObject();
        request.addProperty("last_cache_bust", (Number)lastCacheBustTime);
        body.add("request", (JsonElement)request);
        return this.gzipApi.cacheBust(VungleApiClient.getHeaderUa(), this.cacheBustEndpoint, body);
    }

    public Call<JsonObject> sendAnalytics(Collection<CacheBust> busts) {
        if (this.biLoggingEndpoint == null) {
            throw new IllegalStateException("API Client not configured yet! Must call /config first.");
        }
        if (busts == null || busts.isEmpty()) {
            throw new IllegalArgumentException("Cannot send analytics when bust and session data is empty");
        }
        JsonObject body = new JsonObject();
        body.add("device", (JsonElement)this.getDeviceBody());
        body.add("app", (JsonElement)this.appBody);
        JsonObject request = new JsonObject();
        JsonArray bustsArray = new JsonArray(busts.size());
        for (CacheBust bust : busts) {
            for (int i = 0; i < bust.getEventIds().length; ++i) {
                JsonObject bustElement = new JsonObject();
                bustElement.addProperty("target", bust.getIdType() == 1 ? "campaign" : "creative");
                bustElement.addProperty(ID, bust.getId());
                bustElement.addProperty("event_id", bust.getEventIds()[i]);
                bustsArray.add((JsonElement)bustElement);
            }
        }
        if (bustsArray.size() > 0) {
            request.add("cache_bust", (JsonElement)bustsArray);
        }
        body.add("request", (JsonElement)request);
        return this.gzipApi.sendBiAnalytics(VungleApiClient.getHeaderUa(), this.biLoggingEndpoint, body);
    }

    public Call<JsonObject> sendSessionDataAnalytics(@NonNull JsonArray sessionEvents) {
        if (this.biLoggingEndpoint == null) {
            throw new IllegalStateException("API Client not configured yet! Must call /config first.");
        }
        JsonObject body = new JsonObject();
        body.add("device", (JsonElement)this.getDeviceBody());
        body.add("app", (JsonElement)this.appBody);
        JsonObject request = new JsonObject();
        request.add("session_events", (JsonElement)sessionEvents);
        body.add("request", (JsonElement)request);
        return this.gzipApi.sendBiAnalytics(VungleApiClient.getHeaderUa(), this.biLoggingEndpoint, body);
    }

    @SuppressLint(value={"HardwareIds", "NewApi"})
    private JsonObject getDeviceBody() throws IllegalStateException {
        return this.getDeviceBody(false);
    }

    @SuppressLint(value={"HardwareIds", "NewApi"})
    private synchronized JsonObject getDeviceBody(boolean explicitBlock) throws IllegalStateException {
        boolean isTV;
        String batteryState;
        Intent batteryStatus;
        JsonObject deviceBody = this.baseDeviceInfo.deepCopy();
        JsonObject android = new JsonObject();
        AdvertisingInfo advertisingInfo = this.platform.getAdvertisingInfo();
        boolean limitAdTracking = advertisingInfo.limitAdTracking;
        String advertId = advertisingInfo.advertisingId;
        if (PrivacyManager.getInstance().shouldSendAdIds()) {
            if (advertId != null) {
                android.addProperty("Amazon".equals(Build.MANUFACTURER) ? AMAZON_ADVERTISING_ID : GAID, advertId);
                deviceBody.addProperty(IFA, advertId);
            } else {
                String androidID = this.platform.getAndroidId();
                deviceBody.addProperty(IFA, !TextUtils.isEmpty((CharSequence)androidID) ? androidID : "");
                if (!TextUtils.isEmpty((CharSequence)androidID)) {
                    android.addProperty(ANDROID_ID, androidID);
                }
            }
        }
        if (!PrivacyManager.getInstance().shouldSendAdIds() || explicitBlock) {
            deviceBody.remove(IFA);
            android.remove(ANDROID_ID);
            android.remove(GAID);
            android.remove(AMAZON_ADVERTISING_ID);
        }
        deviceBody.addProperty("lmt", (Number)(limitAdTracking ? 1 : 0));
        boolean isGooglePlaySvcAvailable = Boolean.TRUE.equals(this.isGooglePlayServicesAvailable());
        android.addProperty("is_google_play_services_available", Boolean.valueOf(isGooglePlaySvcAvailable));
        String appSetId = this.platform.getAppSetId();
        if (!TextUtils.isEmpty((CharSequence)appSetId)) {
            android.addProperty("app_set_id", appSetId);
        }
        Intent intent = batteryStatus = this.context != null ? this.context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED")) : null;
        if (batteryStatus != null) {
            int status;
            int level = 0;
            level = batteryStatus.getIntExtra("level", -1);
            int scale = batteryStatus.getIntExtra("scale", -1);
            if (level > 0 && scale > 0) {
                android.addProperty("battery_level", (Number)Float.valueOf((float)level / (float)scale));
            }
            if ((status = batteryStatus.getIntExtra("status", -1)) == -1) {
                batteryState = "UNKNOWN";
            } else if (status == 2 || status == 5) {
                switch (batteryStatus.getIntExtra("plugged", -1)) {
                    case 2: {
                        batteryState = "BATTERY_PLUGGED_USB";
                        break;
                    }
                    case 1: {
                        batteryState = "BATTERY_PLUGGED_AC";
                        break;
                    }
                    case 4: {
                        batteryState = "BATTERY_PLUGGED_WIRELESS";
                        break;
                    }
                    default: {
                        batteryState = "BATTERY_PLUGGED_OTHERS";
                        break;
                    }
                }
            } else {
                batteryState = "NOT_CHARGING";
            }
        } else {
            batteryState = "UNKNOWN";
        }
        android.addProperty("battery_state", batteryState);
        PowerManager powerManager = (PowerManager)this.context.getSystemService("power");
        android.addProperty("battery_saver_enabled", (Number)(powerManager != null && powerManager.isPowerSaveMode() ? 1 : 0));
        if (PermissionChecker.checkCallingOrSelfPermission((Context)this.context, (String)"android.permission.ACCESS_NETWORK_STATE") == 0) {
            NetworkInfo info;
            String connectionType = "NONE";
            String connectionTypeDetail = "unknown";
            ConnectivityManager cm = (ConnectivityManager)this.context.getSystemService("connectivity");
            if (cm != null && (info = cm.getActiveNetworkInfo()) != null) {
                switch (info.getType()) {
                    case 7: {
                        connectionType = "BLUETOOTH";
                        break;
                    }
                    case 9: {
                        connectionType = "ETHERNET";
                        break;
                    }
                    case 0: {
                        connectionType = "MOBILE";
                        connectionTypeDetail = this.getConnectionTypeDetail(info.getSubtype());
                        break;
                    }
                    case 1: 
                    case 6: {
                        connectionType = "WIFI";
                        break;
                    }
                    default: {
                        connectionType = "UNKNOWN";
                    }
                }
            }
            android.addProperty("connection_type", connectionType);
            android.addProperty("connection_type_detail", connectionTypeDetail);
            if (Build.VERSION.SDK_INT >= 24) {
                if (cm.isActiveNetworkMetered()) {
                    String dataSaverStatus;
                    switch (cm.getRestrictBackgroundStatus()) {
                        case 3: {
                            dataSaverStatus = "ENABLED";
                            break;
                        }
                        case 2: {
                            dataSaverStatus = "WHITELISTED";
                            break;
                        }
                        case 1: {
                            dataSaverStatus = "DISABLED";
                            break;
                        }
                        default: {
                            dataSaverStatus = "UNKNOWN";
                        }
                    }
                    android.addProperty("data_saver_status", dataSaverStatus);
                    android.addProperty("network_metered", (Number)1);
                } else {
                    android.addProperty("data_saver_status", "NOT_APPLICABLE");
                    android.addProperty("network_metered", (Number)0);
                }
            }
        }
        android.addProperty("locale", Locale.getDefault().toString());
        android.addProperty("language", Locale.getDefault().getLanguage());
        android.addProperty("time_zone", TimeZone.getDefault().getID());
        AudioManager audio = (AudioManager)this.context.getSystemService("audio");
        if (audio != null) {
            int max = audio.getStreamMaxVolume(3);
            int current = audio.getStreamVolume(3);
            float vol = (float)current / (float)max;
            android.addProperty("volume_level", (Number)Float.valueOf(vol));
            android.addProperty("sound_enabled", (Number)(current > 0 ? 1 : 0));
        }
        File cacheDirectory = this.cacheManager.getCache();
        String cachePath = cacheDirectory.getPath();
        if (cacheDirectory.exists() && cacheDirectory.isDirectory()) {
            android.addProperty("storage_bytes_available", (Number)this.cacheManager.getBytesAvailable());
        }
        if ("Amazon".equals(Build.MANUFACTURER)) {
            String AMAZON_FEATURE_FIRE_TV = "amazon.hardware.fire_tv";
            isTV = this.context.getApplicationContext().getPackageManager().hasSystemFeature("amazon.hardware.fire_tv");
        } else if (Build.VERSION.SDK_INT >= 23) {
            UiModeManager uiModeManager = (UiModeManager)this.context.getSystemService("uimode");
            isTV = uiModeManager.getCurrentModeType() == 4;
        } else {
            String FEATURE_ANDROID_TV = "com.google.android.tv";
            String FEATURE_HW_TOUCHSCREEN = "android.hardware.touchscreen";
            isTV = this.context.getApplicationContext().getPackageManager().hasSystemFeature("com.google.android.tv") || !this.context.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.touchscreen");
        }
        android.addProperty("is_tv", Boolean.valueOf(isTV));
        android.addProperty("os_api_level", (Number)Build.VERSION.SDK_INT);
        android.addProperty("app_target_sdk_version", (Number)this.context.getApplicationInfo().targetSdkVersion);
        if (Build.VERSION.SDK_INT >= 24) {
            android.addProperty("app_min_sdk_version", (Number)this.context.getApplicationInfo().minSdkVersion);
        }
        boolean canInstallNonMarket = false;
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                if (0 == this.context.checkCallingOrSelfPermission("android.permission.REQUEST_INSTALL_PACKAGES")) {
                    canInstallNonMarket = this.context.getApplicationContext().getPackageManager().canRequestPackageInstalls();
                }
            } else {
                canInstallNonMarket = Settings.Secure.getInt((ContentResolver)this.context.getContentResolver(), (String)"install_non_market_apps") == 1;
            }
        }
        catch (Settings.SettingNotFoundException e2) {
            Log.e((String)TAG, (String)"isInstallNonMarketAppsEnabled Settings not found", (Throwable)e2);
        }
        android.addProperty("is_sideload_enabled", Boolean.valueOf(canInstallNonMarket));
        boolean isSDPresent = Environment.getExternalStorageState().equals("mounted");
        android.addProperty("sd_card_available", (Number)(isSDPresent ? 1 : 0));
        android.addProperty("os_name", Build.FINGERPRINT);
        android.addProperty("vduid", "");
        deviceBody.addProperty("ua", this.uaString);
        JsonObject ext = new JsonObject();
        JsonObject vungle = new JsonObject();
        ext.add("vungle", (JsonElement)vungle);
        deviceBody.add("ext", (JsonElement)ext);
        vungle.add("Amazon".equals(Build.MANUFACTURER) ? "amazon" : "android", (JsonElement)android);
        return deviceBody;
    }

    private String getConnectionTypeDetail(int type) {
        switch (type) {
            case 7: {
                return "cdma_1xrtt";
            }
            case 4: {
                return "wcdma";
            }
            case 2: {
                return "edge";
            }
            case 14: {
                return "hrpd";
            }
            case 5: {
                return "cdma_evdo_0";
            }
            case 6: {
                return "cdma_evdo_a";
            }
            case 12: {
                return "cdma_evdo_b";
            }
            case 1: {
                return "gprs";
            }
            case 8: {
                return "hsdpa";
            }
            case 9: {
                return "hsupa";
            }
            case 13: {
                return "LTE";
            }
        }
        return "unknown";
    }

    private JsonObject getUserBody() {
        String messageVersion;
        long timestamp;
        String source;
        String status;
        JsonObject userBody = new JsonObject();
        Cookie consentCookie = this.repository.load("consentIsImportantToVungle", Cookie.class).get(this.timeoutProvider.getTimeout(), TimeUnit.MILLISECONDS);
        if (consentCookie != null) {
            status = consentCookie.getString("consent_status");
            source = consentCookie.getString("consent_source");
            timestamp = consentCookie.getLong("timestamp");
            messageVersion = consentCookie.getString("consent_message_version");
        } else {
            status = "unknown";
            source = "no_interaction";
            timestamp = 0L;
            messageVersion = "";
        }
        JsonObject gdpr = new JsonObject();
        gdpr.addProperty("consent_status", status);
        gdpr.addProperty("consent_source", source);
        gdpr.addProperty("consent_timestamp", (Number)timestamp);
        gdpr.addProperty("consent_message_version", TextUtils.isEmpty((CharSequence)messageVersion) ? "" : messageVersion);
        userBody.add("gdpr", (JsonElement)gdpr);
        Cookie ccpaCookie = this.repository.load("ccpaIsImportantToVungle", Cookie.class).get();
        String ccpaStatus = ccpaCookie != null ? ccpaCookie.getString("ccpa_status") : "opted_in";
        JsonObject ccpa = new JsonObject();
        ccpa.addProperty("status", ccpaStatus);
        userBody.add("ccpa", (JsonElement)ccpa);
        if (PrivacyManager.getInstance().getCoppaStatus() != PrivacyManager.COPPA.COPPA_NOTSET) {
            JsonObject coppaStatusJson = new JsonObject();
            coppaStatusJson.addProperty("is_coppa", Boolean.valueOf(PrivacyManager.getInstance().getCoppaStatus().getValue()));
            userBody.add("coppa", (JsonElement)coppaStatusJson);
        }
        return userBody;
    }

    public boolean getOmEnabled() {
        return this.enableOm;
    }

    private String getUserAgentFromCookie() {
        String tempUserAgent;
        Cookie cookie = this.repository.load("userAgent", Cookie.class).get();
        if (cookie == null) {
            tempUserAgent = System.getProperty("http.agent");
        } else {
            tempUserAgent = cookie.getString("userAgent");
            if (TextUtils.isEmpty((CharSequence)tempUserAgent)) {
                tempUserAgent = System.getProperty("http.agent");
            }
        }
        return tempUserAgent;
    }

    public long getRetryAfterHeaderValue(Response response) {
        String header = response.headers().get("Retry-After");
        try {
            return Long.parseLong(header) * 1000L;
        }
        catch (NumberFormatException ex) {
            return 0L;
        }
    }

    @VisibleForTesting
    void overrideApi(VungleApi api) {
        this.api = api;
    }

    @VisibleForTesting
    public Boolean isGooglePlayServicesAvailable() {
        if (this.isGooglePlayServicesAvailable == null) {
            this.isGooglePlayServicesAvailable = this.getPlayServicesAvailabilityFromCookie();
        }
        if (this.isGooglePlayServicesAvailable == null) {
            this.isGooglePlayServicesAvailable = this.getPlayServicesAvailabilityFromAPI();
        }
        return this.isGooglePlayServicesAvailable;
    }

    @VisibleForTesting
    Boolean getPlayServicesAvailabilityFromCookie() {
        Boolean playSvcAvailability = null;
        Cookie cookie = this.repository.load("isPlaySvcAvailable", Cookie.class).get(this.timeoutProvider.getTimeout(), TimeUnit.MILLISECONDS);
        if (cookie != null) {
            playSvcAvailability = cookie.getBoolean("isPlaySvcAvailable");
        }
        return playSvcAvailability;
    }

    @VisibleForTesting
    Boolean getPlayServicesAvailabilityFromAPI() {
        Boolean result = null;
        try {
            GoogleApiAvailabilityLight googleApiAvailabilityLight = GoogleApiAvailabilityLight.getInstance();
            if (googleApiAvailabilityLight != null) {
                result = googleApiAvailabilityLight.isGooglePlayServicesAvailable(this.context) == 0;
                this.addPlaySvcAvailabilityInCookie(result);
            }
        }
        catch (NoClassDefFoundError error) {
            Log.w((String)TAG, (String)"Play services Not available");
            result = false;
            try {
                this.addPlaySvcAvailabilityInCookie(result);
            }
            catch (DatabaseHelper.DBException e2) {
                Log.w((String)TAG, (String)"Failure to write GPS availability to DB");
            }
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"Unexpected exception from Play services lib.");
        }
        return result;
    }

    @VisibleForTesting
    void addPlaySvcAvailabilityInCookie(boolean isPlaySvcAvailable) throws DatabaseHelper.DBException {
        Cookie cookie = new Cookie("isPlaySvcAvailable");
        cookie.putValue("isPlaySvcAvailable", isPlaySvcAvailable);
        this.repository.save(cookie);
    }

    private JsonObject getExtBody() {
        Cookie cookie = this.repository.load("config_extension", Cookie.class).get(this.timeoutProvider.getTimeout(), TimeUnit.MILLISECONDS);
        String extension = "";
        if (cookie != null) {
            extension = cookie.getString("config_extension");
        }
        if (TextUtils.isEmpty((CharSequence)extension)) {
            return null;
        }
        JsonObject extBody = new JsonObject();
        extBody.addProperty("config_extension", extension);
        return extBody;
    }

    static {
        networkInterceptors = new HashSet<Interceptor>();
        logInterceptors = new HashSet<Interceptor>();
    }

    public static class ClearTextTrafficException
    extends IOException {
        ClearTextTrafficException(String message) {
            super(message);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionTypeDetail {
        public static final String UNKNOWN = "unknown";
        public static final String CDMA_1XRTT = "cdma_1xrtt";
        public static final String WCDMA = "wcdma";
        public static final String EDGE = "edge";
        public static final String HRPD = "hrpd";
        public static final String CDMA_EVDO_0 = "cdma_evdo_0";
        public static final String CDMA_EVDO_A = "cdma_evdo_a";
        public static final String CDMA_EVDO_B = "cdma_evdo_b";
        public static final String GPRS = "gprs";
        public static final String HSDPA = "hsdpa";
        public static final String HSUPA = "hsupa";
        public static final String LTE = "LTE";
    }

    @Keep
    public static enum WrapperFramework {
        admob,
        air,
        cocos2dx,
        corona,
        dfp,
        heyzap,
        marmalade,
        mopub,
        unity,
        fyber,
        ironsource,
        upsight,
        appodeal,
        aerserv,
        adtoapp,
        tapdaq,
        vunglehbs,
        max,
        none;

    }

    static class GzipRequestInterceptor
    implements Interceptor {
        private static final String CONTENT_ENCODING = "Content-Encoding";
        private static final String GZIP = "gzip";

        GzipRequestInterceptor() {
        }

        @NonNull
        public okhttp3.Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
            Request originalRequest = chain.request();
            if (originalRequest.body() == null || originalRequest.header(CONTENT_ENCODING) != null) {
                return chain.proceed(originalRequest);
            }
            Request compressedRequest = originalRequest.newBuilder().header(CONTENT_ENCODING, GZIP).method(originalRequest.method(), this.gzip(originalRequest.body())).build();
            return chain.proceed(compressedRequest);
        }

        private RequestBody gzip(final RequestBody requestBody) throws IOException {
            final Buffer output = new Buffer();
            BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)output));
            requestBody.writeTo(gzipSink);
            gzipSink.close();
            return new RequestBody(){

                public MediaType contentType() {
                    return requestBody.contentType();
                }

                public long contentLength() {
                    return output.size();
                }

                public void writeTo(@NonNull BufferedSink sink) throws IOException {
                    sink.write(output.snapshot());
                }
            };
        }
    }
}

