/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.AdConfig;
import com.vungle.warren.BannerAdConfig;
import com.vungle.warren.Banners;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.SessionTracker;
import com.vungle.warren.Vungle;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.admarkup.AdMarkup;
import com.vungle.warren.ui.view.VungleBannerView;
import com.vungle.warren.utility.AdMarkupDecoder;
import com.vungle.warren.utility.RefreshHandler;
import com.vungle.warren.utility.ViewUtility;
import com.vungle.warren.utility.WeakLoadAdCallback;
import com.vungle.warren.utility.WeakRunnable;

public class VungleBanner
extends RelativeLayout {
    private static final String TAG = VungleBanner.class.getSimpleName();
    private String placementId;
    private int calculatedPixelWidth;
    private int calculatedPixelHeight;
    private boolean destroyed;
    private boolean renderWhenAvailable;
    private boolean disableRenderManagement;
    @Nullable
    private VungleBannerView bannerAd;
    private BannerAdConfig bannerAdConfig;
    private PlayAdCallback playAdCallback;
    private RefreshHandler refreshHandler;
    private boolean renderAdRequested;
    private Runnable refreshAdRunnable = new Runnable(){

        @Override
        public void run() {
            Log.d((String)TAG, (String)"Refresh Timeout Reached");
            VungleBanner.this.renderWhenAvailable = true;
            VungleBanner.this.loadAdInternal();
        }
    };
    private LoadAdCallback loadAdCallback = new LoadAdCallback(){

        @Override
        public void onAdLoad(String placementId) {
            Log.d((String)TAG, (String)("Ad Loaded : " + placementId));
            if (VungleBanner.this.renderWhenAvailable && VungleBanner.this.canRender()) {
                VungleBanner.this.renderWhenAvailable = false;
                VungleBanner.this.finishAdInternal(false);
                VungleBannerView ad = Vungle.getBannerViewInternal(VungleBanner.this.placementId, null, new AdConfig(VungleBanner.this.bannerAdConfig), VungleBanner.this.playAdCallback);
                if (ad != null) {
                    VungleBanner.this.bannerAd = ad;
                    VungleBanner.this.renderAd();
                } else {
                    this.onError(VungleBanner.this.placementId, new VungleException(10));
                    VungleLogger.error(VungleBanner.class.getSimpleName() + "#loadAdCallback; onAdLoad", "VungleBannerView is null");
                }
            }
        }

        @Override
        public void onError(String placementId, VungleException exception) {
            Log.d((String)TAG, (String)("Ad Load Error : " + placementId + " Message : " + exception.getLocalizedMessage()));
            if (VungleBanner.this.getVisibility() == 0 && VungleBanner.this.canRender()) {
                VungleBanner.this.refreshHandler.start();
            }
        }
    };

    protected VungleBanner(@NonNull Context context, String placementId, @Nullable String markup, int adRefreshDuration, BannerAdConfig bannerAdConfig, PlayAdCallback callback) {
        super(context);
        long bannerAdStartTime = System.currentTimeMillis();
        VungleLogger.verbose(true, TAG, "ttDownloadContext", String.format("Creating banner ad, id = %1$s, at: %2$d", placementId, bannerAdStartTime));
        this.placementId = placementId;
        this.bannerAdConfig = bannerAdConfig;
        AdConfig.AdSize adSize = bannerAdConfig.getAdSize();
        this.playAdCallback = callback;
        this.calculatedPixelHeight = ViewUtility.dpToPixels(context, adSize.getHeight());
        this.calculatedPixelWidth = ViewUtility.dpToPixels(context, adSize.getWidth());
        SessionTracker.getInstance().trackAdConfig(bannerAdConfig);
        AdConfig adConfig = new AdConfig(bannerAdConfig);
        AdMarkup adMarkup = AdMarkupDecoder.decode(markup);
        this.bannerAd = Vungle.getBannerViewInternal(placementId, adMarkup, adConfig, this.playAdCallback);
        this.refreshHandler = new RefreshHandler(new WeakRunnable(this.refreshAdRunnable), (long)adRefreshDuration * 1000L);
        VungleLogger.verbose(true, TAG, "ttDownloadContext", String.format("Banner ad created, id = %1$s, elapsed time: %2$dms", placementId, System.currentTimeMillis() - bannerAdStartTime));
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        Log.d((String)TAG, (String)("Banner onWindowVisibilityChanged: " + visibility));
        this.setAdVisibility(visibility == 0);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Log.d((String)TAG, (String)"Banner onAttachedToWindow");
        if (this.disableRenderManagement) {
            return;
        }
        this.renderAd();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.disableRenderManagement) {
            Log.d((String)TAG, (String)"Banner onDetachedFromWindow: render management disabled, do nothing");
            return;
        }
        this.finishAdInternal(true);
    }

    public void renderAd() {
        this.renderAdRequested = true;
        if (this.getVisibility() != 0) {
            return;
        }
        if (this.bannerAd == null) {
            if (this.canRender()) {
                this.renderWhenAvailable = true;
                this.loadAdInternal();
            }
            return;
        }
        View view = this.bannerAd.renderBannerView();
        if (view.getParent() != this) {
            this.addView(view, this.calculatedPixelWidth, this.calculatedPixelHeight);
            Log.d((String)TAG, (String)"Add VungleBannerView to Parent");
        }
        Log.d((String)TAG, (String)("Rendering new ad for: " + this.placementId));
        ViewGroup.LayoutParams bannerLayoutParams = this.getLayoutParams();
        if (bannerLayoutParams != null) {
            bannerLayoutParams.height = this.calculatedPixelHeight;
            bannerLayoutParams.width = this.calculatedPixelWidth;
            this.requestLayout();
        }
        this.refreshHandler.start();
    }

    public void finishAd() {
        this.finishAdInternal(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishAdInternal(boolean isFinishedByApi) {
        VungleBanner vungleBanner = this;
        synchronized (vungleBanner) {
            this.refreshHandler.clean();
            if (this.bannerAd != null) {
                this.bannerAd.finishDisplayingAdInternal(isFinishedByApi);
                this.bannerAd = null;
                try {
                    this.removeAllViews();
                }
                catch (Exception exception) {
                    Log.d((String)TAG, (String)("Removing webview error: " + exception.getLocalizedMessage()));
                }
            }
        }
    }

    public void destroyAd() {
        this.finishAdInternal(true);
        this.destroyed = true;
        this.playAdCallback = null;
    }

    public void setAdVisibility(boolean visible) {
        if (visible && this.canRender()) {
            this.refreshHandler.start();
        } else {
            this.refreshHandler.pause();
        }
        if (this.bannerAd != null) {
            this.bannerAd.setAdVisibility(visible);
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        this.setAdVisibility(hasWindowFocus);
    }

    private boolean canRender() {
        return !this.destroyed && (!this.disableRenderManagement || this.renderAdRequested);
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.setAdVisibility(visibility == 0);
    }

    protected void loadAdInternal() {
        Log.d((String)TAG, (String)"Loading Ad");
        Banners.loadBanner(this.placementId, this.bannerAdConfig, (LoadAdCallback)new WeakLoadAdCallback(this.loadAdCallback));
    }

    public void disableLifeCycleManagement(boolean disable) {
        this.disableRenderManagement = disable;
    }
}

