/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import androidx.annotation.Nullable;
import com.vungle.warren.SessionTracker;
import com.vungle.warren.model.SessionData;
import com.vungle.warren.session.SessionAttribute;
import com.vungle.warren.session.SessionEvent;

public final class VungleSettings {
    private static final long MEGABYTE = 0x100000L;
    private final long minimumSpaceForInit;
    private final long minimumSpaceForAd;
    private final boolean androidIdOptedOut;
    private final long maximumStorageForCleverCache;
    private final boolean disableRefresh;
    private final String priorityPlacement;

    private VungleSettings(Builder builder) {
        this.minimumSpaceForAd = builder.minimumSpaceForAd;
        this.minimumSpaceForInit = builder.minimumSpaceForInit;
        this.androidIdOptedOut = builder.androidIdOptedOut;
        this.disableRefresh = builder.disableRefresh;
        this.maximumStorageForCleverCache = builder.maximumStorageForCleverCache;
        this.priorityPlacement = builder.priorityPlacement;
    }

    public long getMinimumSpaceForAd() {
        return this.minimumSpaceForAd;
    }

    public long getMinimumSpaceForInit() {
        return this.minimumSpaceForInit;
    }

    public boolean getAndroidIdOptOut() {
        return this.androidIdOptedOut;
    }

    public boolean getBannerRefreshDisabled() {
        return this.disableRefresh;
    }

    public long getMaximumStorageForCleverCache() {
        return this.maximumStorageForCleverCache;
    }

    @Nullable
    public String getPriorityPlacement() {
        return this.priorityPlacement;
    }

    public static class Builder {
        private long minimumSpaceForInit = 0x3300000L;
        private long minimumSpaceForAd = 0x3200000L;
        private boolean androidIdOptedOut;
        private long maximumStorageForCleverCache = 0x6400000L;
        private boolean disableRefresh;
        private String priorityPlacement = null;

        public VungleSettings build() {
            return new VungleSettings(this);
        }

        public Builder setMinimumSpaceForInit(long minimumSpaceForInit) {
            this.minimumSpaceForInit = minimumSpaceForInit;
            return this;
        }

        public Builder setMinimumSpaceForAd(long minimumSpaceForAd) {
            this.minimumSpaceForAd = minimumSpaceForAd;
            return this;
        }

        public Builder setAndroidIdOptOut(boolean disabled) {
            this.androidIdOptedOut = disabled;
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.ANDROID_ID).addData(SessionAttribute.USED, !disabled).build());
            return this;
        }

        public Builder disableBannerRefresh() {
            this.disableRefresh = true;
            return this;
        }

        public Builder setMaximumStorageForCleverCache(long maximumStorageForCleverCache) {
            this.maximumStorageForCleverCache = maximumStorageForCleverCache;
            return this;
        }

        public Builder setPriorityPlacement(String priorityPlacement) {
            this.priorityPlacement = priorityPlacement;
            return this;
        }
    }
}

