/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.log;

import android.util.Log;
import androidx.annotation.NonNull;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.log.LogManager;

class JVMCrashCollector
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler defaultExceptionHandler;
    private LogManager.SdkLoggingEventListener sdkLoggingEventListener;
    private String collectFilter = LogManager.sDefaultCollectFilter;

    JVMCrashCollector(@NonNull LogManager.SdkLoggingEventListener sdkLoggingEventListener) {
        this.sdkLoggingEventListener = sdkLoggingEventListener;
        this.defaultExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (this.sdkLoggingEventListener.isCrashReportEnabled() && thread != null && ex != null) {
            boolean crashIsOurConcerned = false;
            block0: for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
                StackTraceElement[] stackTraceElements;
                for (StackTraceElement stackTraceElement : stackTraceElements = cause.getStackTrace()) {
                    if (!stackTraceElement.getClassName().startsWith(this.collectFilter)) continue;
                    crashIsOurConcerned = true;
                    continue block0;
                }
            }
            if (crashIsOurConcerned) {
                String message = Log.getStackTraceString((Throwable)ex);
                String exClass = ex.getClass().toString();
                String threadId = String.valueOf(thread.getId());
                this.sdkLoggingEventListener.saveLog(VungleLogger.LoggerLevel.CRASH, "crash", message, exClass, threadId);
            }
        }
        if (this.defaultExceptionHandler != null) {
            this.defaultExceptionHandler.uncaughtException(thread, ex);
        }
    }

    void updateConfig(@NonNull String filter) {
        this.collectFilter = filter;
    }
}

