/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import androidx.annotation.NonNull;
import com.vungle.warren.VungleLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Cookie {
    public static final String APP_ID = "appId";
    public static final String CONSENT_COOKIE = "consentIsImportantToVungle";
    public static final String CCPA_COOKIE = "ccpaIsImportantToVungle";
    public static final String CCPA_CONSENT_STATUS = "ccpa_status";
    public static final String COPPA_COOKIE = "coppa_cookie";
    public static final String COPPA_KEY = "coppa";
    public static final String COPPA_STATUS_KEY = "is_coppa";
    public static final String COPPA_DISABLE_AD_ID = "disable_ad_id";
    public static final String CONSENT_STATUS_OPTED_IN = "opted_in";
    public static final String CONSENT_STATUS_OPTED_OUT = "opted_out";
    public static final String INCENTIVIZED_TEXT_COOKIE = "incentivizedTextSetByPub";
    public static final String CONFIG_COOKIE = "configSettings";
    public static final String CACHE_BUST_COOKIE = "cacheBustSettings";
    public static final String LAST_CACHE_BUST = "last_cache_bust";
    public static final String USER_AGENT_ID_COOKIE = "userAgent";
    public static final String IS_PLAY_SERVICE_AVAILABLE = "isPlaySvcAvailable";
    public static final String CONFIG_EXTENSION = "config_extension";
    public static final String APP_SET_ID_COOKIE = "appSetIdCookie";
    public static final String APP_SET_ID = "appSetId";
    Map<String, String> strings = new ConcurrentHashMap<String, String>();
    Map<String, Boolean> booleans = new ConcurrentHashMap<String, Boolean>();
    Map<String, Integer> integers = new ConcurrentHashMap<String, Integer>();
    Map<String, Long> longs = new ConcurrentHashMap<String, Long>();
    String identifier;

    public Cookie(String identifier) {
        this.identifier = identifier;
    }

    public <T> void putValue(String key, T value) {
        if (value == null) {
            VungleLogger.critical(true, Cookie.class.getSimpleName(), "putValue", String.format("Value for key \"%s\" should not be null", key));
            return;
        }
        if (value instanceof String) {
            this.strings.put(key, (String)value);
        } else if (value instanceof Boolean) {
            this.booleans.put(key, (Boolean)value);
        } else if (value instanceof Integer) {
            this.integers.put(key, (Integer)value);
        } else if (value instanceof Long) {
            this.longs.put(key, (Long)value);
        } else {
            VungleLogger.critical(true, Cookie.class.getSimpleName(), "putValue", "Value type is not supported!");
        }
    }

    public Integer getInt(String key) {
        return this.integers.get(key);
    }

    public String getString(String key) {
        return this.strings.get(key);
    }

    public Boolean getBoolean(String key) {
        return this.booleans.get(key) != null && this.booleans.get(key) != false;
    }

    public Boolean getBooleanOrNull(String key) {
        return this.booleans.get(key);
    }

    public Long getLong(String key) {
        return this.longs.get(key) != null ? this.longs.get(key) : 0L;
    }

    @NonNull
    public String getId() {
        return this.identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        if (this.strings != null ? !this.strings.equals(cookie.strings) : cookie.strings != null) {
            return false;
        }
        if (this.booleans != null ? !this.booleans.equals(cookie.booleans) : cookie.booleans != null) {
            return false;
        }
        if (this.integers != null ? !this.integers.equals(cookie.integers) : cookie.integers != null) {
            return false;
        }
        if (this.longs != null ? !this.longs.equals(cookie.longs) : cookie.longs != null) {
            return false;
        }
        return this.identifier != null ? this.identifier.equals(cookie.identifier) : cookie.identifier == null;
    }

    public int hashCode() {
        int result = this.strings != null ? this.strings.hashCode() : 0;
        result = 31 * result + (this.booleans != null ? this.booleans.hashCode() : 0);
        result = 31 * result + (this.integers != null ? this.integers.hashCode() : 0);
        result = 31 * result + (this.longs != null ? this.longs.hashCode() : 0);
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        return result;
    }
}

