/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.model.JsonUtil;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.utility.TimeoutProvider;
import java.util.concurrent.TimeUnit;

public class GdprCookie {
    public static String CONSENT_STATUS = "consent_status";
    public static String CONSENT_SOURCE = "consent_source";
    public static String NO_INTERACTION = "no_interaction";
    public static String TIMESTAMP = "timestamp";
    public static String CONSENT_MESSAGE_VERSION = "consent_message_version";
    public static String UNKNOWN = "unknown";
    private final Cookie cookie;
    private final Repository repository;

    public GdprCookie(@NonNull Repository repository, TimeoutProvider timeoutProvider) {
        this.repository = repository;
        Cookie cookie = repository.load("consentIsImportantToVungle", Cookie.class).get(timeoutProvider.getTimeout(), TimeUnit.MILLISECONDS);
        if (cookie == null) {
            cookie = this.createDefaultCookie();
        }
        this.cookie = cookie;
    }

    public String getConsentStatus() {
        return this.cookie != null ? this.cookie.getString(CONSENT_STATUS) : "unknown";
    }

    public String getSource() {
        return this.cookie != null ? this.cookie.getString(CONSENT_SOURCE) : NO_INTERACTION;
    }

    public Long getTimeStamp() {
        return this.cookie != null ? this.cookie.getLong(TIMESTAMP) : 0L;
    }

    public String getMessageVersion() {
        return this.cookie != null ? this.cookie.getString(CONSENT_MESSAGE_VERSION) : "";
    }

    private Cookie createDefaultCookie() {
        Cookie cookie = new Cookie("consentIsImportantToVungle");
        cookie.putValue(CONSENT_MESSAGE_VERSION, "");
        cookie.putValue(CONSENT_STATUS, UNKNOWN);
        cookie.putValue(CONSENT_SOURCE, NO_INTERACTION);
        cookie.putValue(TIMESTAMP, 0L);
        return cookie;
    }

    public void save(JsonObject gdprJsonObject) throws DatabaseHelper.DBException {
        boolean isCountryDataProtected = JsonUtil.hasNonNull((JsonElement)gdprJsonObject, "is_country_data_protected") && gdprJsonObject.get("is_country_data_protected").getAsBoolean();
        String consentTitle = JsonUtil.hasNonNull((JsonElement)gdprJsonObject, "consent_title") ? gdprJsonObject.get("consent_title").getAsString() : "";
        String consentMessage = JsonUtil.hasNonNull((JsonElement)gdprJsonObject, "consent_message") ? gdprJsonObject.get("consent_message").getAsString() : "";
        String consentMessageVersion = JsonUtil.hasNonNull((JsonElement)gdprJsonObject, "consent_message_version") ? gdprJsonObject.get("consent_message_version").getAsString() : "";
        String acceptText = JsonUtil.hasNonNull((JsonElement)gdprJsonObject, "button_accept") ? gdprJsonObject.get("button_accept").getAsString() : "";
        String denyText = JsonUtil.hasNonNull((JsonElement)gdprJsonObject, "button_deny") ? gdprJsonObject.get("button_deny").getAsString() : "";
        this.cookie.putValue("is_country_data_protected", isCountryDataProtected);
        this.cookie.putValue("consent_title", TextUtils.isEmpty((CharSequence)consentTitle) ? "Targeted Ads" : consentTitle);
        this.cookie.putValue("consent_message", TextUtils.isEmpty((CharSequence)consentMessage) ? "To receive more relevant ad content based on your interactions with our ads, click \"I Consent\" below. Either way, you will see the same amount of ads." : consentMessage);
        String strGDPRCurrentSource = this.cookie.getString(CONSENT_SOURCE);
        if (!"publisher".equalsIgnoreCase(strGDPRCurrentSource)) {
            this.cookie.putValue(CONSENT_MESSAGE_VERSION, TextUtils.isEmpty((CharSequence)consentMessageVersion) ? "" : consentMessageVersion);
        }
        this.cookie.putValue("button_accept", TextUtils.isEmpty((CharSequence)acceptText) ? "I Consent" : acceptText);
        this.cookie.putValue("button_deny", TextUtils.isEmpty((CharSequence)denyText) ? "I Do Not Consent" : denyText);
        this.repository.save(this.cookie);
    }
}

