/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import android.content.ContentValues;
import androidx.annotation.NonNull;
import com.vungle.warren.model.SessionData;
import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;

public class SessionDataDBAdapter
implements DBAdapter<SessionData> {
    public static final String CREATE_SESSION_DATA_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS session_data(_id INTEGER PRIMARY KEY AUTOINCREMENT, item_id TEXT UNIQUE,json_string TEXT, send_attempts INT)";

    @Override
    public ContentValues toContentValues(SessionData item) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("item_id", item.getId());
        contentValues.put("json_string", item.getAsJsonString());
        contentValues.put("send_attempts", Integer.valueOf(item.getSendAttempts()));
        return contentValues;
    }

    @Override
    @NonNull
    public SessionData fromContentValues(ContentValues values) {
        SessionData item = new SessionData(values.getAsString("json_string"), values.getAsInteger("send_attempts"));
        return item;
    }

    @Override
    public String tableName() {
        return "session_data";
    }

    public static interface SessionDataColumns
    extends IdColumns {
        public static final String TABLE_NAME = "session_data";
        public static final String JSON_STRING = "json_string";
        public static final String SEND_ATTEMPTS = "send_attempts";
    }
}

